/*
 * Decompiled with CFR 0.152.
 */
package r01f.resources;

import java.nio.charset.Charset;
import r01f.resources.ClassPathResourcesLoader;
import r01f.resources.FileSystemResourcesLoader;
import r01f.resources.ReloadControlBBDDTimeStampBased;
import r01f.resources.ReloadControlContentServerFileLastModifTimeStampBased;
import r01f.resources.ReloadControlFileLastModifTimeStampBased;
import r01f.resources.ReloadControlPeriodic;
import r01f.resources.ReloadControlVoid;
import r01f.resources.ResourcesLoader;
import r01f.resources.ResourcesLoaderBase;
import r01f.resources.ResourcesLoaderDef;
import r01f.resources.ResourcesLoaderFactory;
import r01f.resources.ResourcesReloadControl;
import r01f.resources.ResourcesReloadControlDef;
import r01f.resources.URLResourcesLoader;
import r01f.util.types.Strings;

class ResourcesLoaderFactoryImpl
implements ResourcesLoaderFactory {
    ResourcesLoaderFactoryImpl() {
    }

    @Override
    public ResourcesLoader createResourcesLoaderFor(ResourcesLoaderDef resourcesLoaderDef) {
        ResourcesLoaderBase outResLoader = null;
        if (resourcesLoaderDef != null) {
            switch (resourcesLoaderDef.getLoader()) {
                case BBDD: {
                    break;
                }
                case CONTENT_SERVER: {
                    break;
                }
                case URL: {
                    outResLoader = ResourcesLoaderFactoryImpl._provideURLResourcesLoader(resourcesLoaderDef);
                    break;
                }
                case FILESYSTEM: {
                    outResLoader = ResourcesLoaderFactoryImpl._provideFileSystemResourcesLoader(resourcesLoaderDef);
                    break;
                }
                default: {
                    outResLoader = ResourcesLoaderFactoryImpl._provideClassPathResourcesLoader(resourcesLoaderDef);
                }
            }
        }
        return outResLoader;
    }

    private static FileSystemResourcesLoader _provideFileSystemResourcesLoader(ResourcesLoaderDef resourcesLoaderDef) {
        return new FileSystemResourcesLoader(resourcesLoaderDef);
    }

    private static ClassPathResourcesLoader _provideClassPathResourcesLoader(ResourcesLoaderDef resourcesLoaderDef) {
        return new ClassPathResourcesLoader(resourcesLoaderDef);
    }

    private static URLResourcesLoader _provideURLResourcesLoader(ResourcesLoaderDef resourcesLoaderDef) {
        String proxyHost;
        URLResourcesLoader outResourcesLoader = new URLResourcesLoader(resourcesLoaderDef);
        String charsetName = resourcesLoaderDef.getProperty("charset");
        outResourcesLoader.setServerCharsetName(!Strings.isNullOrEmpty(charsetName) ? charsetName : Charset.defaultCharset().name());
        if (resourcesLoaderDef.getLoaderProps() != null && !Strings.isNullOrEmpty(proxyHost = resourcesLoaderDef.getProperty("proxyHost"))) {
            outResourcesLoader.setProxyHost(proxyHost);
            String proxyPort = resourcesLoaderDef.getProperty("proxyPort");
            outResourcesLoader.setProxyPort(!Strings.isNullOrEmpty(proxyPort) ? proxyPort : "8080");
            String proxyUser = resourcesLoaderDef.getProperty("proxyUser");
            outResourcesLoader.setProxyUser(proxyUser);
            String proxyPassword = resourcesLoaderDef.getProperty("proxyPassword");
            outResourcesLoader.setProxyPassword(proxyPassword);
        }
        return outResourcesLoader;
    }

    @Override
    public ResourcesReloadControl createReloadControlFor(ResourcesReloadControlDef reloadControlDef) {
        ResourcesReloadControl outReloadControl = null;
        switch (reloadControlDef.getImpl()) {
            case BBDD: {
                outReloadControl = new ReloadControlBBDDTimeStampBased();
                break;
            }
            case CONTENT_SERVER_FILE_LAST_MODIF_TIMESTAMP: {
                outReloadControl = new ReloadControlContentServerFileLastModifTimeStampBased();
                break;
            }
            case PERIODIC: {
                outReloadControl = new ReloadControlPeriodic();
                break;
            }
            case FILE_LAST_MODIF_TIMESTAMP: {
                outReloadControl = new ReloadControlFileLastModifTimeStampBased();
                break;
            }
            default: {
                outReloadControl = new ReloadControlVoid();
            }
        }
        return outReloadControl;
    }

    static enum DEFAULT {
        CLASSPATH(ResourcesLoaderDef.ResourcesLoaderType.CLASSPATH);

        private ResourcesLoader _resourcesLoader;

        private DEFAULT(ResourcesLoaderDef.ResourcesLoaderType type) {
            ResourcesLoaderFactoryImpl resLoaderFactoryImpl = new ResourcesLoaderFactoryImpl();
            this._resourcesLoader = resLoaderFactoryImpl.createResourcesLoaderFor(ResourcesLoaderDef.DEFAULT);
        }

        public ResourcesLoader getResourcesLoader() {
            return this._resourcesLoader;
        }
    }
}

