/*
 * Decompiled with CFR 0.152.
 */
package r01f.resources;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import r01f.resources.ResourcesLoaderDef;
import r01f.xmlproperties.XMLProperties;

public class ResourcesLoaderDefLoader {
    private static final Logger log = LoggerFactory.getLogger(ResourcesLoaderDefLoader.class);
    @Inject
    private XMLProperties _xmlProperties;

    public ResourcesLoaderDef loadForDefLocation(String resLoaderDefId) {
        ResourcesLoaderDef resLoaderDef = null;
        if (resLoaderDefId == null || resLoaderDefId.equals("DefaultClassPathLoaderDef")) {
            resLoaderDef = ResourcesLoaderDef.DEFAULT;
        } else {
            Pattern RES_LOADER_PATTERN = Pattern.compile("([^/]+)/([^/]+)/(.+)");
            Matcher m = RES_LOADER_PATTERN.matcher(resLoaderDefId);
            if (m.find() && m.groupCount() == 3) {
                String appCode = m.group(1);
                String component = m.group(2);
                String xPath = m.group(3);
                resLoaderDef = this._xmlProperties.forApp(appCode).of(component).getResourcesLoaderDef(xPath);
            } else {
                log.warn("El atributo resourcesLoaderDef de la anotaci\u00f3n @I18NMessageBundleService NO es correcto; debe tener un formato {appCode}/{component}/{xPath}. Se utiliza ClassPathResourcesLoader");
            }
        }
        if (resLoaderDef == null) {
            log.warn("NO se ha conseguido cargar el resourcesLoaderDef {}; se devuelve el valor por DEFECTO!", (Object)resLoaderDefId);
            resLoaderDef = ResourcesLoaderDef.DEFAULT;
        }
        return resLoaderDef;
    }
}

