/*
 * Decompiled with CFR 0.152.
 */
package r01f.resources;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import r01f.debug.Debuggable;
import r01f.internal.BuiltInObjectsMarshaller;
import r01f.marshalling.MarshallerException;
import r01f.resources.ResourcesReloadControlDef;
import r01f.util.types.Strings;

public class ResourcesLoaderDef
implements Debuggable {
    public static ResourcesLoaderDef DEFAULT = new ResourcesLoaderDef(){

        @Override
        public ResourcesLoaderType getLoader() {
            return ResourcesLoaderType.CLASSPATH;
        }

        @Override
        public ResourcesReloadControlDef getReloadControlDef() {
            return ResourcesReloadControlDef.DEFAULT;
        }
    };
    private String _name;
    private ResourcesLoaderType _loader;
    private Map<String, String> _loaderProps;
    private ResourcesReloadControlDef _reloadControlDef;

    public String getProperty(String propName) {
        String outProp = this.getLoaderProps() != null ? this.getLoaderProps().get(propName) : null;
        return outProp;
    }

    @Override
    public CharSequence debugInfo() {
        Strings.StringWrapper sw = Strings.create(100);
        sw.addCustomized("\r\n\t      name:", this._name);
        sw.addCustomized("\r\n\t\tloaderId: {}", this._loader.name()).addCustomized("\r\n\t\t   props: ({})", this._loaderProps == null ? "null" : Integer.toString(this._loaderProps.size()));
        if (this._loaderProps != null) {
            for (Map.Entry<String, String> prop : this._loaderProps.entrySet()) {
                sw.addCustomized("\r\n\t\t\t-{}:{}", prop.getKey(), prop.getValue());
            }
        }
        sw.addCustomized("\r\n\t\treloadControl:{}", this._reloadControlDef != null ? this._reloadControlDef.debugInfo() : "none");
        return sw;
    }

    public static ResourcesLoaderDef forDefinition(String defXml) throws IllegalArgumentException {
        return ResourcesLoaderDef.forDefinition(new ByteArrayInputStream(defXml.getBytes()));
    }

    public static ResourcesLoaderDef forDefinition(InputStream defXmlIS) throws IllegalArgumentException {
        ResourcesLoaderDef resLoaderDef = null;
        try {
            resLoaderDef = (ResourcesLoaderDef)BuiltInObjectsMarshaller.instance().beanFromXml(defXmlIS);
        }
        catch (MarshallerException msEx) {
            throw new IllegalArgumentException("NO se puede cargar la definici\u00f3n del ResourcesLoader a partir del XML de definici\u00f3n proporcionado. Probablemente el XML NO es correcto: " + msEx.getMessage(), msEx);
        }
        return resLoaderDef;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String _name) {
        this._name = _name;
    }

    public ResourcesLoaderType getLoader() {
        return this._loader;
    }

    public void setLoader(ResourcesLoaderType _loader) {
        this._loader = _loader;
    }

    public Map<String, String> getLoaderProps() {
        return this._loaderProps;
    }

    public void setLoaderProps(Map<String, String> _loaderProps) {
        this._loaderProps = _loaderProps;
    }

    public ResourcesReloadControlDef getReloadControlDef() {
        return this._reloadControlDef;
    }

    public void setReloadControlDef(ResourcesReloadControlDef _reloadControlDef) {
        this._reloadControlDef = _reloadControlDef;
    }

    public static enum ResourcesLoaderType {
        CLASSPATH,
        FILESYSTEM,
        URL,
        CONTENT_SERVER,
        BBDD;

    }
}

