/*
 * Decompiled with CFR 0.152.
 */
package r01f.resources;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import r01f.resources.ResourcesReloadControl;

public class ReloadControlPeriodic
implements ResourcesReloadControl {
    private static String PERIOD_PROP_KEY = "period";
    private long _lastReloadTimeStamp = System.currentTimeMillis();
    private long _reloadPeriodMillis = -1L;

    @Override
    public void setProperties(Map<String, String> props) {
        if (props == null) {
            return;
        }
        String periodStr = props.get(PERIOD_PROP_KEY);
        if (periodStr == null) {
            return;
        }
        Matcher m = Pattern.compile("\\s*([0-9]+)\\s*(s|m|h)\\s*").matcher(periodStr);
        if (m.matches()) {
            int periodValue = Integer.parseInt(m.group(1));
            String periodUnitStr = m.group(2);
            if (periodUnitStr.equalsIgnoreCase("s")) {
                this._reloadPeriodMillis = periodValue * 1000;
            } else if (periodUnitStr.equalsIgnoreCase("m")) {
                this._reloadPeriodMillis = periodValue * 60 * 1000;
            } else if (periodUnitStr.equalsIgnoreCase("h")) {
                this._reloadPeriodMillis = periodValue * 60 * 60 * 1000;
            }
        }
    }

    @Override
    public boolean needsReload(String component) {
        long currentTimeMillis;
        long elapsedTime;
        boolean outReload = false;
        if (this._reloadPeriodMillis > 0L && (elapsedTime = (currentTimeMillis = System.currentTimeMillis()) - this._lastReloadTimeStamp) > this._reloadPeriodMillis) {
            outReload = true;
            this._lastReloadTimeStamp = currentTimeMillis;
        }
        return outReload;
    }
}

