/*
 * Decompiled with CFR 0.152.
 */
package r01f.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import r01f.resources.ResourcesLoaderBase;
import r01f.resources.ResourcesLoaderDef;

public class ClassPathResourcesLoader
extends ResourcesLoaderBase {
    ClassPathResourcesLoader(ResourcesLoaderDef def) {
        super.setDef(def);
    }

    @Override
    public InputStream getInputStream(String resourcePath, boolean reload) throws IOException {
        String theResourcePath = resourcePath.startsWith("/") ? resourcePath.substring(1) : resourcePath;
        InputStream outResourceIS = null;
        ClassLoader loader = ClassPathResourcesLoader.class.getClassLoader();
        if (reload) {
            URLConnection connection;
            URL url = loader.getResource(theResourcePath);
            if (url != null && (connection = url.openConnection()) != null) {
                connection.setUseCaches(false);
                outResourceIS = connection.getInputStream();
            }
        } else {
            outResourceIS = loader.getResourceAsStream(theResourcePath);
        }
        return outResourceIS;
    }

    @Override
    public Reader getReader(String resourcePath, boolean reload) throws IOException {
        return new InputStreamReader(this.getInputStream(resourcePath, reload));
    }
}

