/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection.fluent;

import r01f.reflection.fluent.TypeInvoker;
import r01f.util.types.Strings;

public final class TypeReflection {
    private final String _className;

    private TypeReflection(String className) {
        this._className = className;
    }

    static TypeReflection startTypeAccess(String className) {
        if (className == null) {
            throw new NullPointerException("The name of the class to load should not be null");
        }
        if (Strings.isNullOrEmpty(className)) {
            throw new IllegalArgumentException("The name of the class to load should not be empty");
        }
        return new TypeReflection(className);
    }

    public TypeInvoker withClassLoader(ClassLoader classLoader) {
        return TypeInvoker.newLoader(this._className, classLoader);
    }

    public Class<?> load() {
        return TypeInvoker.newLoader(this._className, this.thisClassLoader()).load();
    }

    public <T> Class<? extends T> loadAs(Class<T> type) {
        return TypeInvoker.newLoader(this._className, this.thisClassLoader()).loadAs(type);
    }

    private ClassLoader thisClassLoader() {
        return this.getClass().getClassLoader();
    }
}

