/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection.fluent;

import r01f.reflection.ReflectionException;
import r01f.util.types.Strings;

public final class TypeInvoker {
    private final String _className;
    private final ClassLoader _classLoader;

    private TypeInvoker(String className, ClassLoader classLoader) {
        this._className = className;
        this._classLoader = classLoader;
    }

    static TypeInvoker newLoader(String className, ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("The given class loader should not be null");
        }
        return new TypeInvoker(className, classLoader);
    }

    public Class<?> load() {
        try {
            return this._loadType();
        }
        catch (Exception e) {
            throw new ReflectionException(this._composeUnableToLoadClassMessage(null), e);
        }
    }

    public <T> Class<? extends T> loadAs(Class<T> type) {
        if (type == null) {
            throw new NullPointerException("The given type should not be null");
        }
        try {
            return this._loadType().asSubclass(type);
        }
        catch (Exception e) {
            throw new ReflectionException(this._composeUnableToLoadClassMessage(type), e);
        }
    }

    private Class<?> _loadType() throws ClassNotFoundException {
        return this._classLoader.loadClass(this._className);
    }

    private String _composeUnableToLoadClassMessage(Class<?> asType) {
        StringBuilder msg = Strings.of((CharSequence)"Unable to load class ").addQuoted(this._className).asStringBuilder();
        if (asType != null) {
            msg.append(" as ").append(asType.getName());
        }
        msg.append(" using class loader ").append(this._classLoader);
        return msg.toString();
    }
}

