/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection.fluent;

import r01f.generics.TypeRef;
import r01f.reflection.fluent.MethodInvoker;
import r01f.reflection.fluent.StaticMethodParameterTypes;

public class StaticMethodReturnTypes {
    static <T> StaticMethodReturnType<T> newReturnType(String methodName, Class<T> type) {
        if (type == null) {
            throw new NullPointerException("The return type of the static method to access should not be null");
        }
        return new StaticMethodReturnType(methodName);
    }

    static <T> StaticMethodReturnTypeGenerics<T> newReturnTypeGenerics(String methodName, TypeRef<T> type) {
        if (type == null) {
            throw new NullPointerException("The return type reference of the static method to access should not be null");
        }
        return new StaticMethodReturnTypeGenerics(methodName);
    }

    public static class StaticMethodReturnType<T> {
        private final String _methodName;

        StaticMethodReturnType(String methodName) {
            this._methodName = methodName;
        }

        public MethodInvoker<T> in(Class<?> target) {
            return MethodInvoker.newInvoker(this._methodName, target, new Class[0]);
        }

        public StaticMethodParameterTypes<T> withParameterTypes(Class<?> ... parameterTypes) {
            return StaticMethodParameterTypes.newParameterTypes(this._methodName, parameterTypes);
        }
    }

    public static class StaticMethodReturnTypeGenerics<T> {
        private final String _methodName;

        StaticMethodReturnTypeGenerics(String methodName) {
            this._methodName = methodName;
        }

        public MethodInvoker<T> in(Class<?> target) {
            return MethodInvoker.newInvoker(this._methodName, target, new Class[0]);
        }

        public StaticMethodParameterTypes<T> withParameterTypes(Class<?> ... parameterTypes) {
            return StaticMethodParameterTypes.newParameterTypes(this._methodName, parameterTypes);
        }
    }
}

