/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection.fluent;

import r01f.generics.TypeRef;
import r01f.reflection.fluent.MethodInvoker;
import r01f.reflection.fluent.StaticMethodParameterTypes;
import r01f.reflection.fluent.StaticMethodReturnTypes;
import r01f.util.types.Strings;

public final class StaticMethodReflection {
    private final String _methodName;

    private StaticMethodReflection(String methodName) {
        this._methodName = methodName;
    }

    static StaticMethodReflection startStaticMethodAccess(String methodName) {
        StaticMethodReflection._validateIsNotNullOrEmpty(methodName);
        return new StaticMethodReflection(methodName);
    }

    public <T> StaticMethodReturnTypes.StaticMethodReturnType<T> withReturnType(Class<T> type) {
        return StaticMethodReturnTypes.newReturnType(this._methodName, type);
    }

    public <T> StaticMethodReturnTypes.StaticMethodReturnTypeGenerics<T> withReturnType(TypeRef<T> type) {
        return StaticMethodReturnTypes.newReturnTypeGenerics(this._methodName, type);
    }

    public StaticMethodParameterTypes<Void> withParameterTypes(Class<?> ... parameterTypes) {
        return StaticMethodParameterTypes.newParameterTypes(this._methodName, parameterTypes);
    }

    public MethodInvoker<Void> in(Class<?> target) {
        return MethodInvoker.newInvoker(this._methodName, target, new Class[0]);
    }

    private static void _validateIsNotNullOrEmpty(String methodName) {
        if (methodName == null) {
            throw new NullPointerException("The name of the static method to access should not be null");
        }
        if (Strings.isNullOrEmpty(methodName)) {
            throw new IllegalArgumentException("The name of the static method to access should not be empty");
        }
    }
}

