/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection.fluent;

import r01f.reflection.fluent.StaticInnerClassInvoker;
import r01f.util.types.Strings;

public final class StaticInnerClassReflection {
    private final String _innerClassName;

    private StaticInnerClassReflection(String name) {
        this._innerClassName = name;
    }

    static StaticInnerClassReflection startStaticInnerClassAccess(String name) {
        StaticInnerClassReflection._validateIsNotNullOrEmpty(name);
        return new StaticInnerClassReflection(name);
    }

    public StaticInnerClassInvoker in(Class<?> declaringClass) {
        return StaticInnerClassInvoker.newInvoker(declaringClass, this._innerClassName);
    }

    private static void _validateIsNotNullOrEmpty(String innerClassName) {
        if (innerClassName == null) {
            throw new NullPointerException("The name of the static inner class to access should not be null");
        }
        if (Strings.isNullOrEmpty(innerClassName)) {
            throw new IllegalArgumentException("The name of the static inner class to access should not be empty");
        }
    }
}

