/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection.fluent;

import r01f.reflection.ReflectionException;
import r01f.util.types.Strings;

public class StaticInnerClassInvoker {
    private final Class<?> _declaringClass;
    private final String _innerClassName;

    private StaticInnerClassInvoker(Class<?> declaringClass, String innerClassName) {
        this._declaringClass = declaringClass;
        this._innerClassName = innerClassName;
    }

    static StaticInnerClassInvoker newInvoker(Class<?> declaringClass, String innerClassName) {
        if (declaringClass == null) {
            throw new NullPointerException("The declaring class should not be null");
        }
        return new StaticInnerClassInvoker(declaringClass, innerClassName);
    }

    public Class<?> get() {
        String namespace = this._declaringClass.getName();
        Class<?>[] classArray = this._declaringClass.getDeclaredClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> innerClass = classArray[n2];
            if (innerClass.getName().equals(this._expectedInnerClassName(namespace))) {
                return innerClass;
            }
            ++n2;
        }
        throw new ReflectionException(Strings.of("The static inner class <", this._innerClassName, "> cannot be found in ", this._declaringClass.getName()).toString());
    }

    private String _expectedInnerClassName(String namespace) {
        return Strings.of(namespace, "$", this._innerClassName).toString();
    }
}

