/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection.fluent;

import r01f.generics.TypeRef;
import r01f.reflection.fluent.FieldInvoker;

public class StaticFieldTypes {
    static <T> StaticFieldType<T> newFieldType(String fieldName, Class<T> fieldType) {
        if (fieldType == null) {
            throw new NullPointerException("The type of the static field to access should not be null");
        }
        return new StaticFieldType<T>(fieldName, fieldType);
    }

    static <T> StaticFieldTypeGenerics<T> newFieldTypeGenerics(String fieldName, TypeRef<T> fieldType) {
        if (fieldType == null) {
            throw new NullPointerException("The type reference of the static field to access should not be null");
        }
        return new StaticFieldTypeGenerics<T>(fieldName, fieldType);
    }

    public static class StaticFieldType<T> {
        private final String _fieldName;
        private final Class<T> _fieldType;

        StaticFieldType(String fieldName, Class<T> fieldType) {
            this._fieldName = fieldName;
            this._fieldType = fieldType;
        }

        public FieldInvoker<T> in(Class<?> target) {
            return FieldInvoker.newInvoker(this._fieldName, this._fieldType, target);
        }
    }

    public static class StaticFieldTypeGenerics<T> {
        private final String _fieldName;
        private final TypeRef<T> _fieldType;

        StaticFieldTypeGenerics(String fieldName, TypeRef<T> fieldType) {
            this._fieldName = fieldName;
            this._fieldType = fieldType;
        }

        public FieldInvoker<T> in(Class<?> target) {
            return FieldInvoker.newInvoker(this._fieldName, this._fieldType, target);
        }
    }
}

