/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection.fluent;

import r01f.generics.TypeRef;
import r01f.reflection.fluent.StaticFieldTypes;
import r01f.util.types.Strings;

public final class StaticFieldReflection {
    private final String _fieldName;

    private StaticFieldReflection(String fieldName) {
        this._fieldName = fieldName;
    }

    static StaticFieldReflection startStaticFieldAccess(String fieldName) {
        StaticFieldReflection._validateIsNotNullOrEmpty(fieldName);
        return new StaticFieldReflection(fieldName);
    }

    public <T> StaticFieldTypes.StaticFieldType<T> ofType(Class<T> type) {
        return StaticFieldTypes.newFieldType(this._fieldName, type);
    }

    public <T> StaticFieldTypes.StaticFieldTypeGenerics<T> ofType(TypeRef<T> type) {
        return StaticFieldTypes.newFieldTypeGenerics(this._fieldName, type);
    }

    private static void _validateIsNotNullOrEmpty(String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("The name of the static field to access should not be null");
        }
        if (Strings.isNullOrEmpty(fieldName)) {
            throw new IllegalArgumentException("The name of the static field to access should not be empty");
        }
    }
}

