/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection.fluent;

import r01f.generics.TypeRef;
import r01f.reflection.fluent.PropertyInvoker;

public class PropertyTypes {
    static <T> PropertyType<T> newPropertyType(String name, Class<T> type) {
        if (type == null) {
            throw new NullPointerException("The type of the property to access should not be null");
        }
        return new PropertyType<T>(name, type);
    }

    static <T> PropertyTypeGenerics<T> newPropertyTypeGenerics(String name, TypeRef<T> type) {
        if (type == null) {
            throw new NullPointerException("The type reference of the property to access should not be null");
        }
        return new PropertyTypeGenerics<T>(name, type);
    }

    public static class PropertyType<T> {
        private final String _propertyName;
        private final Class<T> _propertyType;

        PropertyType(String propertyName, Class<T> type) {
            this._propertyName = propertyName;
            this._propertyType = type;
        }

        public PropertyInvoker<T> in(Object target) {
            if (target == null) {
                throw new NullPointerException("Target should not be null");
            }
            return PropertyInvoker.newInvoker(this._propertyName, this._propertyType, target);
        }
    }

    public static class PropertyTypeGenerics<T> {
        private final String _propertyName;
        private final TypeRef<T> _propertyType;

        PropertyTypeGenerics(String name, TypeRef<T> type) {
            this._propertyName = name;
            this._propertyType = type;
        }

        public PropertyInvoker<T> in(Object target) {
            return PropertyInvoker.newInvoker(this._propertyName, this._propertyType, target);
        }
    }
}

