/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection.fluent;

import r01f.generics.TypeRef;
import r01f.reflection.fluent.PropertyTypes;
import r01f.util.types.Strings;

public final class PropertyReflection {
    private final String _propertyName;

    private PropertyReflection(String name) {
        this._propertyName = name;
    }

    static PropertyReflection startPropertyAccess(String propertyName) {
        PropertyReflection.validateIsNotNullOrEmpty(propertyName);
        return new PropertyReflection(propertyName);
    }

    public <T> PropertyTypes.PropertyType<T> ofType(Class<T> type) {
        return PropertyTypes.newPropertyType(this._propertyName, type);
    }

    public <T> PropertyTypes.PropertyTypeGenerics<T> ofType(TypeRef<T> type) {
        return PropertyTypes.newPropertyTypeGenerics(this._propertyName, type);
    }

    private static void validateIsNotNullOrEmpty(String name) {
        if (name == null) {
            throw new NullPointerException("The name of the property to access should not be null");
        }
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("The name of the property to access should not be empty");
        }
    }
}

