/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection.fluent;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import r01f.generics.TypeRef;
import r01f.reflection.ReflectionException;
import r01f.util.types.Strings;

public final class PropertyInvoker<T> {
    private final String _propertyName;
    private final Object _targetObj;
    private final PropertyDescriptor _propertyDescriptor;

    private PropertyInvoker(String propertyName, Object target, PropertyDescriptor descriptor) {
        this._propertyName = propertyName;
        this._targetObj = target;
        this._propertyDescriptor = descriptor;
    }

    static <T> PropertyInvoker<T> newInvoker(String propertyName, TypeRef<T> expectedType, Object target) {
        return PropertyInvoker._createInvoker(propertyName, expectedType.rawType(), target);
    }

    static <T> PropertyInvoker<T> newInvoker(String propertyName, Class<T> expectedType, Object target) {
        return PropertyInvoker._createInvoker(propertyName, expectedType, target);
    }

    public void set(T value) {
        try {
            this._propertyDescriptor.getWriteMethod().invoke(this._targetObj, value);
        }
        catch (Exception ex) {
            throw new ReflectionException(ex).inType(this._targetObj).inField(this._propertyName);
        }
    }

    public T get() {
        try {
            return (T)this._propertyDescriptor.getReadMethod().invoke(this._targetObj, new Object[0]);
        }
        catch (Exception ex) {
            throw new ReflectionException(ex).inType(this._targetObj).inField(this._propertyName);
        }
    }

    public PropertyDescriptor info() {
        return this._propertyDescriptor;
    }

    private static <T> PropertyInvoker<T> _createInvoker(String name, Class<?> expectedType, Object target) {
        PropertyDescriptor descriptor = PropertyInvoker._descriptorForProperty(name, target);
        PropertyInvoker._verifyCorrectType(name, target, expectedType, descriptor);
        return new PropertyInvoker<T>(name, target, descriptor);
    }

    private static void _verifyCorrectType(String propertyName, Object target, Class<?> expectedType, PropertyDescriptor descriptor) {
        Class<?> actualType = descriptor.getPropertyType();
        if (!expectedType.isAssignableFrom(actualType)) {
            throw PropertyInvoker._incorrectPropertyType(propertyName, target, actualType, expectedType);
        }
    }

    private static PropertyDescriptor _descriptorForProperty(String propertyName, Object target) {
        BeanInfo beanInfo = null;
        Class<?> type = target.getClass();
        try {
            beanInfo = Introspector.getBeanInfo(type, Object.class);
        }
        catch (IntrospectionException ex) {
            throw new ReflectionException(Strings.of((CharSequence)"Unable to get BeanInfo for type ").add((CharSequence)type.getName()).toString(), ex);
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor d = propertyDescriptorArray[n2];
            if (propertyName.equals(d.getName())) {
                return d;
            }
            ++n2;
        }
        throw new ReflectionException().noFieldException().inType(target).inField(propertyName);
    }

    private static ReflectionException _incorrectPropertyType(String name, Object target, Class<?> actual, Class<?> expected) {
        String typeName = target.getClass().getName();
        String msg = Strings.of((CharSequence)"The type of the property ").addQuoted(name).add((CharSequence)" in ").add((CharSequence)typeName).add((CharSequence)" should be <").add((CharSequence)expected.getName()).add((CharSequence)"> but was <").add((CharSequence)actual.getName()).add((CharSequence)">").toString();
        throw new ReflectionException(msg);
    }
}

