/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection.fluent;

import r01f.generics.TypeRef;
import r01f.reflection.fluent.MethodInvoker;
import r01f.reflection.fluent.MethodParameterTypes;

public class MethodReturnTypes {
    static <T> MethodReturnType<T> newReturnType(String methodName, Class<T> type) {
        if (type == null) {
            throw new NullPointerException("The return type of the method to access should not be null");
        }
        return new MethodReturnType(methodName);
    }

    static <T> MethodReturnTypeGenerics<T> newReturnTypeGenerics(String methodName, TypeRef<T> type) {
        if (type == null) {
            throw new NullPointerException("The return type reference of the method to access should not be null");
        }
        return new MethodReturnTypeGenerics(methodName);
    }

    public static class MethodReturnType<T> {
        private final String _methodName;

        MethodReturnType(String methodName) {
            this._methodName = methodName;
        }

        public MethodInvoker<T> in(Object target) {
            return MethodInvoker.newInvoker(this._methodName, target, new Class[0]);
        }

        public MethodParameterTypes<T> withParameterTypes(Class<?> ... parameterTypes) {
            return MethodParameterTypes.newParameterTypes(this._methodName, parameterTypes);
        }
    }

    public static class MethodReturnTypeGenerics<T> {
        private final String _methodName;

        MethodReturnTypeGenerics(String methodName) {
            this._methodName = methodName;
        }

        public MethodInvoker<T> in(Object target) {
            return MethodInvoker.newInvoker(this._methodName, target, new Class[0]);
        }

        public MethodParameterTypes<T> withParameterTypes(Class<?> ... parameterTypes) {
            return MethodParameterTypes.newParameterTypes(this._methodName, parameterTypes);
        }
    }
}

