/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection.fluent;

import r01f.generics.TypeRef;
import r01f.reflection.fluent.MethodInvoker;
import r01f.reflection.fluent.MethodParameterTypes;
import r01f.reflection.fluent.MethodReturnTypes;
import r01f.util.types.Strings;

public final class MethodReflection {
    private final String _methodName;

    private MethodReflection(String name) {
        this._methodName = name;
    }

    static MethodReflection startMethodAccess(String methodName) {
        MethodReflection._validateIsNotNullOrEmpty(methodName);
        return new MethodReflection(methodName);
    }

    public <T> MethodReturnTypes.MethodReturnType<T> withReturnType(Class<T> type) {
        return MethodReturnTypes.newReturnType(this._methodName, type);
    }

    public <T> MethodReturnTypes.MethodReturnTypeGenerics<T> withReturnType(TypeRef<T> type) {
        return MethodReturnTypes.newReturnTypeGenerics(this._methodName, type);
    }

    public MethodParameterTypes<Void> withParameterTypes(Class<?> ... parameterTypes) {
        return MethodParameterTypes.newParameterTypes(this._methodName, parameterTypes);
    }

    public MethodInvoker<Void> in(Object target) {
        return MethodInvoker.newInvoker(this._methodName, target, new Class[0]);
    }

    private static void _validateIsNotNullOrEmpty(String methodName) {
        if (methodName == null) {
            throw new NullPointerException("The name of the method to access should not be null");
        }
        if (Strings.isNullOrEmpty(methodName)) {
            throw new IllegalArgumentException("The name of the method to access should not be empty");
        }
    }
}

