/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection.fluent;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import r01f.reflection.ReflectionException;
import r01f.reflection.ReflectionUtils;

public final class MethodInvoker<T> {
    private final Object _targetObj;
    private final Method _method;

    private MethodInvoker(Object target, Method method) {
        this._targetObj = target;
        this._method = method;
    }

    static <T> MethodInvoker<T> newInvoker(String methodName, Object target, Class<?> ... parameterTypes) {
        return MethodInvoker._createInvoker(methodName, target, parameterTypes);
    }

    public T invoke(Object ... args) {
        boolean accessible = this._method.isAccessible();
        try {
            ReflectionUtils.makeAccessible(this._method);
            Object object = this._method.invoke(this._targetObj, args);
            return (T)object;
        }
        catch (Throwable t) {
            Throwable cause;
            Throwable throwable = cause = t instanceof InvocationTargetException ? t.getCause() : t;
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw this._cannotInvokeMethod(cause, args);
        }
        finally {
            ReflectionUtils.setAccessibleIgnoringExceptions(this._method, accessible);
        }
    }

    public Method getMethod() {
        return this._method;
    }

    private static <T> MethodInvoker<T> _createInvoker(String methodName, Object target, Class<?> ... parameterTypes) {
        if (target == null) {
            throw new NullPointerException("Target should not be null");
        }
        Method method = MethodInvoker._lookupInClassHierarchy(methodName, MethodInvoker.typeOf(target), parameterTypes);
        return new MethodInvoker<T>(target, method);
    }

    private static Class<?> typeOf(Object target) {
        if (target instanceof Class) {
            return (Class)target;
        }
        return target.getClass();
    }

    private static Method _lookupInClassHierarchy(String methodName, Class<?> targetType, Class<?>[] parameterTypes) {
        Method method = null;
        Class<?> type = targetType;
        while (type != null) {
            method = MethodInvoker._findMethod(type, methodName, parameterTypes);
            if (method != null) break;
            type = type.getSuperclass();
        }
        if (method == null) {
            throw new ReflectionException().noMethodException();
        }
        return method;
    }

    private static Method _findMethod(Class<?> type, String methodName, Class<?>[] parameterTypes) {
        try {
            return type.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private ReflectionException _cannotInvokeMethod(Throwable cause, Object ... args) {
        throw new ReflectionException(cause).inType(this._targetObj).inMethod(this._method, args);
    }
}

