/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection.fluent;

import r01f.generics.TypeRef;
import r01f.reflection.fluent.FieldInvoker;

public class FieldTypes {
    static <T> FieldType<T> newFieldType(String fieldName, Class<T> fieldType) {
        if (fieldType == null) {
            throw new NullPointerException("The type of the field to access should not be null");
        }
        return new FieldType<T>(fieldName, fieldType);
    }

    static <T> FieldTypeGenerics<T> newFieldTypeGenerics(String name, TypeRef<T> type) {
        if (type == null) {
            throw new NullPointerException("The type reference of the field to access should not be null");
        }
        return new FieldTypeGenerics<T>(name, type);
    }

    public static class FieldType<T> {
        final String _fieldName;
        final Class<T> _fieldType;

        FieldType(String fieldName, Class<T> fieldType) {
            this._fieldName = fieldName;
            this._fieldType = fieldType;
        }

        public FieldInvoker<T> in(Object target) {
            return FieldInvoker.newInvoker(this._fieldName, this._fieldType, target);
        }
    }

    public static class FieldTypeGenerics<T> {
        private final String _fieldName;
        private final TypeRef<T> _fieldType;

        FieldTypeGenerics(String name, TypeRef<T> type) {
            this._fieldName = name;
            this._fieldType = type;
        }

        public FieldInvoker<T> in(Object target) {
            return FieldInvoker.newInvoker(this._fieldName, this._fieldType, target);
        }
    }
}

