/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection.fluent;

import r01f.generics.TypeRef;
import r01f.reflection.fluent.FieldTypes;
import r01f.util.types.Strings;

public final class FieldReflection {
    private final String _fieldName;

    private FieldReflection(String fieldName) {
        this._fieldName = fieldName;
    }

    static FieldReflection startFieldAccess(String fieldName) {
        FieldReflection._validateIsNotNullOrEmpty(fieldName);
        return new FieldReflection(fieldName);
    }

    public <T> FieldTypes.FieldType<T> ofType(Class<T> type) {
        return FieldTypes.newFieldType(this._fieldName, type);
    }

    public <T> FieldTypes.FieldTypeGenerics<T> ofType(TypeRef<T> type) {
        return FieldTypes.newFieldTypeGenerics(this._fieldName, type);
    }

    private static void _validateIsNotNullOrEmpty(String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("The name of the field to access should not be null");
        }
        if (Strings.isNullOrEmpty(fieldName)) {
            throw new IllegalArgumentException("The name of the field to access should not be empty");
        }
    }
}

