/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection.fluent;

import java.lang.reflect.Field;
import r01f.generics.TypeRef;
import r01f.reflection.ReflectionException;
import r01f.reflection.ReflectionUtils;
import r01f.util.types.Strings;

public final class FieldInvoker<T> {
    private final Object _targetObj;
    private final Field _field;
    private final boolean _accessible;

    private FieldInvoker(Object target, Field field) {
        this._targetObj = target;
        this._field = field;
        this._accessible = field.isAccessible();
    }

    static <T> FieldInvoker<T> newInvoker(String fieldName, Class<T> expectedType, Object target) {
        return FieldInvoker._createInvoker(fieldName, expectedType, target);
    }

    static <T> FieldInvoker<T> newInvoker(String fieldName, TypeRef<T> expectedType, Object target) {
        return FieldInvoker._createInvoker(fieldName, expectedType.rawType(), target);
    }

    public void set(T value) {
        try {
            try {
                ReflectionUtils.setAccessible(this._field, true);
                this._field.set(this._targetObj, value);
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
        finally {
            ReflectionUtils.setAccessibleIgnoringExceptions(this._field, this._accessible);
        }
    }

    public T get() {
        try {
            Object outFieldValue;
            ReflectionUtils.setAccessible(this._field, true);
            Object object = outFieldValue = this._field.get(this._targetObj);
            return (T)object;
        }
        catch (Exception ex) {
            throw new ReflectionException(ex);
        }
        finally {
            ReflectionUtils.setAccessibleIgnoringExceptions(this._field, this._accessible);
        }
    }

    public Field getField() {
        return this._field;
    }

    private static <T> FieldInvoker<T> _createInvoker(String fieldName, Class<?> expectedType, Object target) {
        if (target == null) {
            throw new NullPointerException("Target should not be null");
        }
        Field field = FieldInvoker._lookupInClassHierarchy(fieldName, FieldInvoker._typeOf(target));
        FieldInvoker._makeAccessible(field);
        FieldInvoker._verifyCorrectType(field, expectedType);
        return new FieldInvoker<T>(target, field);
    }

    private static Class<?> _typeOf(Object target) {
        if (target instanceof Class) {
            return (Class)target;
        }
        return target.getClass();
    }

    private static Field _lookupInClassHierarchy(String fieldName, Class<?> declaringType) {
        Field field = null;
        Class<?> target = declaringType;
        while (target != null) {
            field = FieldInvoker._field(fieldName, target);
            if (field != null) break;
            target = target.getSuperclass();
        }
        if (field != null) {
            return field;
        }
        throw new ReflectionException().inType(declaringType).inField(fieldName).noFieldException();
    }

    private static void _makeAccessible(Field field) {
        boolean isAccessible = field.isAccessible();
        try {
            ReflectionUtils.makeAccessible(field);
        }
        finally {
            ReflectionUtils.setAccessibleIgnoringExceptions(field, isAccessible);
        }
    }

    private static void _verifyCorrectType(Field field, Class<?> expectedType) {
        if (expectedType == null) {
            return;
        }
        Class<?> actualType = field.getType();
        if (!expectedType.isAssignableFrom(actualType)) {
            throw FieldInvoker._incorrectFieldType(field, actualType, expectedType);
        }
    }

    private static Field _field(String fieldName, Class<?> declaringType) {
        try {
            return declaringType.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static ReflectionException _incorrectFieldType(Field field, Class<?> actual, Class<?> expected) {
        String fieldTypeName = field.getDeclaringClass().getName();
        String message = Strings.of((CharSequence)"The type of the field ").addQuoted(field.getName()).add(" in ", fieldTypeName, " should be <", expected.getName(), "> but was <", actual.getName(), ">").toString();
        throw new ReflectionException(message);
    }
}

