/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection.fluent;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import r01f.reflection.ReflectionException;
import r01f.reflection.ReflectionUtils;

public final class ConstructorInvoker<T> {
    private final Constructor<T> _constructor;

    private ConstructorInvoker(Constructor<T> constructor) {
        this._constructor = constructor;
    }

    public static <T> ConstructorInvoker<T> newInvoker(Class<T> target, Class<?> ... parameterTypes) {
        Constructor<T> constructor = ConstructorInvoker.constructor(target, parameterTypes);
        return new ConstructorInvoker<T>(constructor);
    }

    public T newInstance(Object ... args) {
        boolean accessible = this._constructor.isAccessible();
        try {
            T newInstance;
            ReflectionUtils.makeAccessible(this._constructor);
            T t = newInstance = this._constructor.newInstance(args);
            return t;
        }
        catch (Throwable t) {
            Throwable cause;
            Throwable throwable = cause = t instanceof InvocationTargetException ? t.getCause() : t;
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new ReflectionException(cause).instantiationException();
        }
        finally {
            ReflectionUtils.setAccessibleIgnoringExceptions(this._constructor, accessible);
        }
    }

    public Constructor<T> getConstructor() {
        return this._constructor;
    }

    private static <T> Constructor<T> constructor(Class<T> target, Class<?> ... parameterTypes) {
        try {
            return target.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException nsmEx) {
            throw new ReflectionException(nsmEx).noConstructorException().inType(target.getClass()).inConstructor(parameterTypes);
        }
    }
}

