/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import r01f.reflection.ReflectionException;
import r01f.util.types.collections.ArrayFormatter;
import r01f.util.types.collections.CollectionUtils;

public class ReflectionUtils {
    private static final Set<Class<?>> FINAL_IMMUTABLE_CLASSES = new HashSet(17);
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private static final Class<?>[] EMPTY_CLASS_ARRAY;

    static {
        FINAL_IMMUTABLE_CLASSES.add(String.class);
        FINAL_IMMUTABLE_CLASSES.add(Byte.class);
        FINAL_IMMUTABLE_CLASSES.add(Short.class);
        FINAL_IMMUTABLE_CLASSES.add(Integer.class);
        FINAL_IMMUTABLE_CLASSES.add(Long.class);
        FINAL_IMMUTABLE_CLASSES.add(Float.class);
        FINAL_IMMUTABLE_CLASSES.add(Double.class);
        FINAL_IMMUTABLE_CLASSES.add(Character.class);
        FINAL_IMMUTABLE_CLASSES.add(Boolean.class);
        FINAL_IMMUTABLE_CLASSES.add(java.util.Date.class);
        FINAL_IMMUTABLE_CLASSES.add(Date.class);
        EMPTY_OBJECT_ARRAY = new Object[0];
        EMPTY_CLASS_ARRAY = new Class[0];
    }

    public static boolean isFinalInmutable(Class<?> type) {
        return type.isPrimitive() || FINAL_IMMUTABLE_CLASSES.contains(type);
    }

    public static String classNameFromClassName(String classNameIncludingPackage) {
        if (classNameIncludingPackage == null || classNameIncludingPackage.length() == 0) {
            return "";
        }
        if (classNameIncludingPackage.indexOf(46) < 0) {
            return classNameIncludingPackage;
        }
        Pattern p = Pattern.compile("^.*\\.([^.]+)$");
        Matcher m = p.matcher(classNameIncludingPackage);
        if (!m.matches()) {
            return "";
        }
        return m.group(1);
    }

    public static String packageFromClassName(String classNameIncludingPackage) {
        if (classNameIncludingPackage == null || classNameIncludingPackage.length() == 0) {
            return "";
        }
        if (classNameIncludingPackage.indexOf(46) < 0) {
            return "";
        }
        Pattern p = Pattern.compile("^(.*)\\.[^.]+$");
        Matcher m = p.matcher(classNameIncludingPackage);
        if (!m.matches()) {
            return "";
        }
        return m.group(1);
    }

    public static String[] classAndPackageFromClassName(String classNameIncludingPackage) {
        if (classNameIncludingPackage == null || classNameIncludingPackage.length() == 0) {
            return new String[0];
        }
        if (classNameIncludingPackage.indexOf(46) < 0) {
            String[] stringArray = new String[2];
            stringArray[1] = classNameIncludingPackage;
            return stringArray;
        }
        Pattern p = Pattern.compile("^(.*)\\.([^.]+)$");
        Matcher m = p.matcher(classNameIncludingPackage);
        if (!m.matches()) {
            return new String[0];
        }
        return new String[]{m.group(1), m.group(2)};
    }

    public static boolean isImplementing(Class<?> type, Class<?> theInterface) {
        return theInterface.isAssignableFrom(type);
    }

    public static boolean isSubClassOf(Class<?> type, Class<?> superType) {
        boolean isAssignable = superType.isAssignableFrom(type);
        return isAssignable;
    }

    public static boolean isSubClassOf(Object theObj, Object theBaseObj) {
        if (theObj == null && theBaseObj != null) {
            return false;
        }
        if (theObj != null && theBaseObj == null) {
            return false;
        }
        return ReflectionUtils.isSubClassOf(theObj.getClass(), theBaseObj.getClass());
    }

    public static boolean isSameClassAs(Class<?> type, Class<?> otherType) {
        return type.equals(otherType);
    }

    public static boolean isSameClassAs(Object theObj, Object theOtherObj) {
        if (theObj == null && theOtherObj == null) {
            return false;
        }
        if (theObj == null && theOtherObj != null) {
            return false;
        }
        if (theObj != null && theOtherObj == null) {
            return false;
        }
        return ReflectionUtils.isSameClassAs(theObj.getClass(), theOtherObj.getClass());
    }

    public static Class<?> typeFromClassName(String className) {
        if (className == null) {
            throw new ReflectionException("No se puede obtener la definicion de la clase: el nombre suministrado es null").classNotFoundException();
        }
        Class<?> objType = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            try {
                objType = cl.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (objType == null) {
                try {
                    objType = Class.forName(className);
                }
                catch (ClassNotFoundException cnfEx) {
                    throw new ReflectionException(cnfEx).inType(className);
                }
            }
        }
        if (objType == null) {
            throw new ReflectionException("No se ha podido obtener la definici\u00f3n de la clase").classNotFoundException();
        }
        return objType;
    }

    public static <T> Class<? extends T> typeFromClassName(String className, Class<T> type) {
        Class<?> rawType = ReflectionUtils.typeFromClassName(className);
        return rawType.asSubclass(type);
    }

    public static Annotation[] typeAnnotations(Class<?> type) {
        return type.getAnnotations();
    }

    public static <A extends Annotation> A typeAnnotation(Class<?> type, Class<A> annotationType) {
        return type.getAnnotation(annotationType);
    }

    public static <T> T createInstanceOf(String className) {
        T outObj = ReflectionUtils.createInstanceOf(className, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY, true);
        return outObj;
    }

    public static <T> T createInstanceOf(Class<?> type) {
        T outObj = ReflectionUtils.createInstanceOf(type, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY, true);
        return outObj;
    }

    public static <T> T createInstanceOf(String className, Class<?>[] constructorArgsTypes, Object[] constructorArgs) {
        T outObj = ReflectionUtils.createInstanceOf(className, constructorArgsTypes, constructorArgs, true);
        return outObj;
    }

    public static <T> T createInstanceOf(String className, Class<?>[] constructorArgsTypes, Object[] constructorArgs, boolean force) {
        Class<?> objClassDef = ReflectionUtils.typeFromClassName(className);
        T outObj = ReflectionUtils.createInstanceOf(objClassDef, constructorArgsTypes, constructorArgs, force);
        return outObj;
    }

    public static <T> T createInstanceOf(Class<?> type, Class<?>[] constructorArgsTypes, Object[] constructorArgs) {
        T outObj = ReflectionUtils.createInstanceOf(type, constructorArgsTypes, constructorArgs, true);
        return outObj;
    }

    public static <T> T createInstanceOf(Class<?> type, Class<?>[] constructorArgsTypes, Object[] constructorArgs, boolean force) {
        if (type == null) {
            return null;
        }
        T newObj = null;
        Constructor<?> constructor = null;
        try {
            constructor = ConstructorUtils.getAccessibleConstructor(type, (Class[])(constructorArgsTypes != null ? constructorArgsTypes : new Class[]{}));
            if (constructor == null && force) {
                constructor = type.getDeclaredConstructor(constructorArgsTypes != null ? constructorArgsTypes : new Class[]{});
                if (force) {
                    ReflectionUtils.makeAccessible(constructor);
                }
            }
            if (constructor != null) {
                newObj = constructor.newInstance(constructorArgs != null ? constructorArgs : new Object[]{});
            }
        }
        catch (Throwable th) {
            throw new ReflectionException(th).inType(type.getCanonicalName()).inConstructor(constructorArgsTypes);
        }
        T outObj = newObj;
        return outObj;
    }

    public static Method[] allMethods(Class<?> type) {
        ArrayList<Method> methods = new ArrayList<Method>();
        Class<?> c = type;
        while (c != Object.class) {
            Method[] declaredMethods = c.getDeclaredMethods();
            if (declaredMethods != null) {
                methods.addAll(Arrays.asList(declaredMethods));
            }
            c = c.getSuperclass();
        }
        Method[] outMethods = new Method[methods.size()];
        return methods.toArray(outMethods);
    }

    public static Method staticMethod(Class<?> type, String methodName, Class<?> ... argsTypes) {
        Method method = ReflectionUtils.method(type, methodName, argsTypes);
        return method;
    }

    public static Method method(Class<?> type, String methodName, Class<?> ... paramTypes) {
        Method outMethod = null;
        Class<?> c = type;
        while (c != Object.class) {
            try {
                Method m = c.getDeclaredMethod(methodName, paramTypes != null ? paramTypes : new Class[]{});
                if (m != null) {
                    outMethod = m;
                    break;
                }
            }
            catch (NoSuchMethodException m) {
                // empty catch block
            }
            c = c.getSuperclass();
        }
        if (outMethod == null) {
            c = type;
            while (c != Object.class) {
                Method[] methods;
                Method[] methodArray = methods = c.getDeclaredMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m = methodArray[n2];
                    if (m.getName().equals(methodName)) {
                        outMethod = m;
                        break;
                    }
                    ++n2;
                }
                c = c.getSuperclass();
            }
        }
        if (outMethod == null) {
            throw new ReflectionException().inType(type.getCanonicalName()).inMethod(methodName, paramTypes).noMethodException();
        }
        return outMethod;
    }

    public static Object invokeMethod(Object obj, Method method, Object ... argValues) {
        if (obj == null) {
            throw new ReflectionException("NO se ha pasado una instancia del bean sobre el que invocar el metodo. Si se trata de un metodo estatico llama a invokeStaticMethod").illegalArgumentException();
        }
        if (method == null) {
            throw new ReflectionException("No se puede invocar al metodo NULL!!!").inType(obj.getClass().getCanonicalName()).noMethodException();
        }
        try {
            ReflectionUtils.makeAccessible(method);
            return method.invoke(obj, argValues != null ? argValues : new Object[]{});
        }
        catch (Throwable th) {
            throw new ReflectionException(th).inType(obj.getClass().getCanonicalName()).inMethod(method.toString(), new Class[0]);
        }
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?>[] argsTypes, Object[] argsValues) {
        if (obj == null) {
            throw new ReflectionException("NO se ha pasado una instancia del bean sobre el que invocar el metodo. Si se trata de un metodo estatico llama a invokeStaticMethod").illegalArgumentException();
        }
        if (methodName == null) {
            throw new ReflectionException("No se puede invocar al metodo NULL!!!").inType(obj.getClass().getCanonicalName()).noMethodException();
        }
        try {
            return MethodUtils.invokeMethod((Object)obj, (String)methodName, (Object[])argsValues, (Class[])argsTypes);
        }
        catch (Throwable th) {
            throw new ReflectionException(th).inType(obj.getClass().getCanonicalName()).inMethod(methodName, argsTypes);
        }
    }

    public static Object invokeStaticMethod(Class<?> type, String methodName, Class<?>[] argsTypes, Object[] argsValues) {
        Method method = ReflectionUtils.method(type, methodName, argsTypes);
        return ReflectionUtils.invokeMethod(type, method, argsValues);
    }

    public static Object invokeStaticMethod(Class<?> type, Method method, Object ... argsValues) {
        if (type == null) {
            throw new ReflectionException("NO se puede invocar un metodo estatico si no se conoce la clase sobre la que invocar").classNotFoundException();
        }
        if (method == null) {
            throw new ReflectionException("No se puede invocar al metodo NULL!!!").inType(type.getCanonicalName()).noMethodException();
        }
        try {
            return MethodUtils.invokeStaticMethod(type, (String)method.getName(), (Object[])argsValues, (Class[])method.getParameterTypes());
        }
        catch (Throwable th) {
            throw new ReflectionException(th).inType(type.getCanonicalName()).inMethod(method.getName(), method.getParameterTypes());
        }
    }

    public static Map<String, Field> allFieldsMap(Class<?> type) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Class<?> c = type;
        while (c != Object.class) {
            Field[] declaredFields = c.getDeclaredFields();
            if (declaredFields != null && declaredFields.length > 0) {
                int i = 0;
                while (i < declaredFields.length) {
                    fields.put(declaredFields[i].getName(), declaredFields[i]);
                    ++i;
                }
            }
            c = c.getSuperclass();
        }
        return fields;
    }

    public static Map<String, Field> allFieldsMap(Class<?> type, boolean forceAccesible) {
        Map<String, Field> outFields = ReflectionUtils.allFieldsMap(type);
        if (!CollectionUtils.isNullOrEmpty(outFields)) {
            for (Field f : outFields.values()) {
                ReflectionUtils.makeAccessible(f);
            }
        }
        return outFields;
    }

    public static Field[] allFields(Class<?> type) {
        Map<String, Field> fields = ReflectionUtils.allFieldsMap(type);
        return fields.size() > 0 ? fields.values().toArray(new Field[fields.size()]) : new Field[]{};
    }

    public static Field field(Class<?> type, String fieldName) {
        Class<?> c = type;
        while (c != Object.class) {
            try {
                Field f = c.getDeclaredField(fieldName);
                return f;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                c = c.getSuperclass();
            }
        }
        throw new ReflectionException().inType(type.getCanonicalName()).inField(fieldName).noFieldException();
    }

    public static Field field(Class<?> type, String fieldName, boolean forceAccesible) {
        Field f = ReflectionUtils.field(type, fieldName);
        if (f != null && forceAccesible) {
            ReflectionUtils.makeAccessible(f);
        }
        return f;
    }

    public static Field[] fieldsOfType(Class<?> type, Class<?> fieldType) {
        return ReflectionUtils.fieldsOfAnyType(type, fieldType);
    }

    public static Field[] fieldsOfAnyType(Class<?> type, Class<?> ... fieldTypes) {
        ArrayList<Field> outFields = new ArrayList<Field>();
        Class<?> c = type;
        while (c != Object.class) {
            Field[] fieldArray = c.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                Class<?>[] classArray = fieldTypes;
                int n3 = fieldTypes.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<?> fieldType = classArray[n4];
                    if (ReflectionUtils.isSubClassOf(f.getType(), fieldType)) {
                        outFields.add(f);
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
            c = c.getSuperclass();
        }
        return !CollectionUtils.isNullOrEmpty(outFields) ? outFields.toArray(new Field[outFields.size()]) : new Field[]{};
    }

    public static Field[] fieldsOfType(Class<?> type, Class<?> fieldType, boolean forceAccesible) {
        Field[] fields = ReflectionUtils.fieldsOfType(type, fieldType);
        if (!CollectionUtils.isNullOrEmpty(fields)) {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                ReflectionUtils.makeAccessible(f);
                ++n2;
            }
        }
        return fields;
    }

    public static Class<?> fieldType(Class<?> type, String fieldName) {
        Field f = ReflectionUtils.field(type, fieldName, false);
        return f.getType();
    }

    public static Field fieldFor(Object containerObject, Object memberInstance) {
        Field[] mapFields;
        if (containerObject == null || memberInstance == null) {
            return null;
        }
        Field outField = null;
        Field[] fieldArray = mapFields = ReflectionUtils.fieldsOfType(containerObject.getClass(), memberInstance.getClass(), true);
        int n = mapFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            Object fValue = ReflectionUtils.fieldValue(containerObject, f, false);
            if (fValue == memberInstance) {
                outField = f;
            }
            ++n2;
        }
        return outField;
    }

    private static Method _fieldSetterName(Class<?> type, String fieldName, Class<?> memberType) {
        Method outMethod;
        block8: {
            String setter = null;
            outMethod = null;
            if (memberType == Boolean.class || memberType == Boolean.TYPE) {
                try {
                    setter = "set" + StringUtils.capitalize((String)fieldName);
                    outMethod = ReflectionUtils.method(type, setter, memberType);
                }
                catch (ReflectionException nsmEx) {
                    if (nsmEx.isNoMethodException()) {
                        setter = "set" + (fieldName.startsWith("is") ? StringUtils.capitalize((String)fieldName.substring(2)) : StringUtils.capitalize((String)fieldName));
                    }
                }
            } else {
                setter = "set" + StringUtils.capitalize((String)fieldName);
            }
            try {
                if (outMethod == null && setter != null) {
                    outMethod = ReflectionUtils.method(type, setter, memberType);
                }
            }
            catch (ReflectionException nsmEx) {
                if (!nsmEx.isNoFieldExcepton()) break block8;
                outMethod = null;
            }
        }
        return outMethod;
    }

    private static void _setFieldValueWithoutUsingAccessors(Class<?> type, Object obj, String fieldName, Object value) {
        Field memberField = ReflectionUtils.field(type, fieldName, true);
        try {
            memberField.set(obj, value);
        }
        catch (IllegalArgumentException illArgEx) {
            String msg = "El tipo esperado es " + memberField.getType() + " y se ha pasado un objeto de tipo " + value.getClass();
            throw new ReflectionException(msg, illArgEx).inType(type.getCanonicalName()).inField(fieldName);
        }
        catch (Throwable th) {
            throw new ReflectionException(th).inType(type.getCanonicalName()).inField(fieldName);
        }
    }

    public static void setStaticFieldValue(Class<?> type, String fieldName, Object value) {
        ReflectionUtils._setFieldValueWithoutUsingAccessors(type, null, fieldName, value);
    }

    public static void setFieldValue(Object obj, Field field, Object value, boolean useAccessors) {
        ReflectionUtils.setFieldValue(obj, field.getName(), value, useAccessors);
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        ReflectionUtils.setFieldValue(obj, fieldName, value, true);
    }

    public static void setFieldValue(Object obj, String fieldName, Object value, boolean useAccessor) {
        block9: {
            if (value == null) {
                return;
            }
            if (obj == null) {
                throw new ReflectionException("No se puede establecer la variable " + fieldName + " ya que el objeto es nulo!!!");
            }
            try {
                if (useAccessor) {
                    try {
                        PropertyUtils.setProperty((Object)obj, (String)fieldName, (Object)value);
                    }
                    catch (Throwable th) {
                        Method accessorMethod;
                        Class<?> valueType = CollectionUtils.getCollectionType(value.getClass());
                        if (valueType == null) {
                            valueType = value.getClass();
                        }
                        if ((accessorMethod = ReflectionUtils._fieldSetterName(obj.getClass(), fieldName, valueType)) != null) {
                            ReflectionUtils.invokeMethod(obj, accessorMethod, value);
                            break block9;
                        }
                        ReflectionUtils.setFieldValue(obj, fieldName, value, false);
                    }
                    break block9;
                }
                ReflectionUtils._setFieldValueWithoutUsingAccessors(obj.getClass(), obj, fieldName, value);
            }
            catch (Throwable th) {
                throw new ReflectionException(th).inType(obj.getClass().getCanonicalName()).inField(fieldName);
            }
        }
    }

    public static Method _fieldGetterName(Class<?> type, String fieldName, Class<?> memberType) {
        Method outMethod;
        block10: {
            String getter;
            block9: {
                outMethod = null;
                getter = null;
                if (memberType != null && (memberType == Boolean.class || memberType == Boolean.TYPE)) {
                    try {
                        getter = "get" + StringUtils.capitalize((String)fieldName);
                        outMethod = ReflectionUtils.method(type, getter, memberType);
                    }
                    catch (ReflectionException nsmEx) {
                        if (!nsmEx.isNoMethodException()) break block9;
                        getter = "is" + (fieldName.startsWith("is") ? StringUtils.capitalize((String)fieldName.substring(2)) : StringUtils.capitalize((String)fieldName));
                        try {
                            outMethod = ReflectionUtils.method(type, getter, memberType);
                            break block9;
                        }
                        catch (ReflectionException nsmEx2) {
                            if (nsmEx2.isNoMethodException()) {
                                getter = "get" + (fieldName.startsWith("is") ? StringUtils.capitalize((String)fieldName.substring(2)) : StringUtils.capitalize((String)fieldName));
                            }
                            break block9;
                        }
                    }
                }
                getter = "get" + StringUtils.capitalize((String)fieldName);
            }
            try {
                if (outMethod == null && getter != null) {
                    outMethod = ReflectionUtils.method(type, getter, memberType);
                }
            }
            catch (ReflectionException nsmEx) {
                if (!nsmEx.isNoFieldExcepton()) break block10;
                outMethod = null;
            }
        }
        return outMethod;
    }

    private static <T> T _getFieldValueWithoutUsingAccessors(Class<?> type, Object obj, String fieldName) {
        Field memberField = ReflectionUtils.field(type, fieldName, true);
        try {
            Object outObj = memberField.get(obj);
            return (T)outObj;
        }
        catch (Throwable th) {
            throw new ReflectionException(th).inType(type.getCanonicalName()).inField(fieldName);
        }
    }

    public static <T> T getStaticFieldValue(Class<?> type, String fieldName) {
        return ReflectionUtils._getFieldValueWithoutUsingAccessors(type, null, fieldName);
    }

    public static <T> T fieldValue(Object obj, Field field, boolean useAccessor) {
        T outObj = ReflectionUtils.fieldValue(obj, field.getName(), field.getType(), useAccessor);
        return outObj;
    }

    public static <T> T fieldValue(Object obj, String fieldName, boolean useAccessor) {
        T outObj = ReflectionUtils.fieldValue(obj, fieldName, null, useAccessor);
        return outObj;
    }

    public static <T> T fieldValue(Object obj, String fieldName, Class<?> fieldType, boolean useAccessor) {
        if (obj == null) {
            throw new ReflectionException("No se puede obtener el valor de la variable " + fieldName + " ya que el objeto es nulo!!!").classNotFoundException();
        }
        try {
            Object outObj;
            block9: {
                outObj = null;
                if (useAccessor) {
                    try {
                        outObj = PropertyUtils.getProperty((Object)obj, (String)fieldName);
                    }
                    catch (Throwable th) {
                        Method accessorMethod;
                        Class<?> valueType;
                        Class<?> clazz = valueType = fieldType != null ? CollectionUtils.getCollectionType(fieldType) : null;
                        if (valueType == null) {
                            valueType = fieldType;
                        }
                        if ((accessorMethod = ReflectionUtils._fieldSetterName(obj.getClass(), fieldName, valueType)) != null) {
                            outObj = ReflectionUtils.invokeMethod(obj, accessorMethod, new Object[0]);
                            break block9;
                        }
                        outObj = ReflectionUtils.fieldValue(obj, fieldName, null, false);
                    }
                } else {
                    outObj = ReflectionUtils._getFieldValueWithoutUsingAccessors(obj.getClass(), obj, fieldName);
                }
            }
            Object theObj = outObj;
            return (T)theObj;
        }
        catch (Throwable th) {
            throw new ReflectionException(th).inType(obj.getClass().getCanonicalName()).inField(fieldName);
        }
    }

    public static Map<Class<? extends Annotation>, FieldAnnotated<? extends Annotation>[]> fieldsAnnotated(Class<?> annotationType) {
        HashMap fieldsAnnotatedMap = new HashMap();
        Field[] fields = ReflectionUtils.allFields(annotationType);
        if (fields != null && fields.length > 0) {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                Annotation[] annots = f.getAnnotations();
                if (annots != null) {
                    Annotation[] annotationArray = annots;
                    int n3 = annots.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Annotation annot = annotationArray[n4];
                        ArrayList<FieldAnnotated<Annotation>> fieldsAnnotated = (ArrayList<FieldAnnotated<Annotation>>)fieldsAnnotatedMap.get(annot);
                        if (fieldsAnnotated == null) {
                            fieldsAnnotated = new ArrayList<FieldAnnotated<Annotation>>();
                            fieldsAnnotatedMap.put(annot.getClass(), fieldsAnnotated);
                        }
                        fieldsAnnotated.add(new FieldAnnotated<Annotation>(f, annot));
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        HashMap<Class, FieldAnnotated[]> outFields = null;
        if (!CollectionUtils.isNullOrEmpty(fieldsAnnotatedMap)) {
            outFields = new HashMap<Class, FieldAnnotated[]>(fieldsAnnotatedMap.size());
            for (Map.Entry me : fieldsAnnotatedMap.entrySet()) {
                outFields.put((Class)me.getKey(), ((List)me.getValue()).toArray(new FieldAnnotated[((List)me.getValue()).size()]));
            }
        }
        return outFields;
    }

    public static <A extends Annotation> FieldAnnotated<A>[] fieldsAnnotated(Class<?> type, Class<A> annotationType) {
        ArrayList<FieldAnnotated<A>> outList = new ArrayList<FieldAnnotated<A>>();
        Field[] fields = ReflectionUtils.allFields(type);
        if (fields != null && fields.length > 0) {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                A annot = f.getAnnotation(annotationType);
                if (annot != null) {
                    outList.add(new FieldAnnotated<A>(f, annot));
                }
                ++n2;
            }
        }
        if (!CollectionUtils.isNullOrEmpty(outList)) {
            return outList.toArray(new FieldAnnotated[outList.size()]);
        }
        return null;
    }

    public static Class<?> classOfType(Type type) {
        Type componentType;
        Class<?> componentClass;
        Class<?> outClass = null;
        if (type instanceof Class) {
            outClass = (Class<?>)type;
        } else if (type instanceof ParameterizedType) {
            outClass = ReflectionUtils.classOfType(((ParameterizedType)type).getRawType());
        } else if (type instanceof GenericArrayType && (componentClass = ReflectionUtils.classOfType(componentType = ((GenericArrayType)type).getGenericComponentType())) != null) {
            outClass = Array.newInstance(componentClass, 0).getClass();
        }
        return outClass;
    }

    public static Class<?> collectionFieldComponentType(Field field) {
        Class outCollectionComponentClass = null;
        if (field.getType().isArray()) {
            outCollectionComponentClass = field.getType().getComponentType();
        } else {
            ParameterizedType collectionComponentType = (ParameterizedType)field.getGenericType();
            outCollectionComponentClass = (Class)collectionComponentType.getActualTypeArguments()[0];
        }
        return outCollectionComponentClass;
    }

    public static Class<?>[] mapFieldKeyValueComponentTypes(Field field) {
        ParameterizedType mapComponentType = (ParameterizedType)field.getGenericType();
        Class[] outKeyAndValueTypes = new Class[]{(Class)mapComponentType.getActualTypeArguments()[0], (Class)mapComponentType.getActualTypeArguments()[1]};
        return outKeyAndValueTypes;
    }

    public static void setAccessibleIgnoringExceptions(AccessibleObject o, boolean accessible) {
        try {
            ReflectionUtils.setAccessible(o, accessible);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static void makeAccessible(AccessibleObject o) {
        ReflectionUtils.setAccessible(o, true);
    }

    public static void setAccessible(AccessibleObject o, boolean accessible) {
        AccessController.doPrivileged(new SetAccessibleAction(o, accessible));
    }

    public static void setFieldValueUsingPath(Object obj, String memberPath, Object memberValue, boolean useAccesors) {
        if (obj == null || memberPath == null) {
            throw new IllegalArgumentException("El objeto o el path NO son v\u00e1lidos");
        }
        StringTokenizer st = new StringTokenizer(memberPath, ".");
        String currFieldName = null;
        Object currObj = obj;
        do {
            currFieldName = st.nextToken();
            if (st.hasMoreTokens()) {
                Object instance = ReflectionUtils.fieldValue(currObj, currFieldName, null, useAccesors);
                if (instance == null) {
                    Class<?> currInstanceClass = null;
                    currInstanceClass = useAccesors ? ReflectionUtils.fieldType(currObj.getClass(), currFieldName) : ReflectionUtils.field(currObj.getClass(), currFieldName, true).getType();
                    if (currInstanceClass.isArray() || CollectionUtils.isCollection(currInstanceClass) || CollectionUtils.isMap(currInstanceClass)) {
                        throw new ReflectionException("De momento el metodo setMemberValueUsingPath NO soporta elementos tipo array, lista o map en el path");
                    }
                    instance = ReflectionUtils.createInstanceOf(currInstanceClass);
                    ReflectionUtils.setFieldValue(currObj, currFieldName, instance, useAccesors);
                }
                currObj = instance;
                continue;
            }
            ReflectionUtils.setFieldValue(currObj, currFieldName, memberValue, useAccesors);
        } while (st.hasMoreTokens());
    }

    public static Object getMemberValueUsingPath(Object obj, String memberPath, boolean useAccesors) {
        if (obj == null || memberPath == null) {
            throw new IllegalArgumentException("El objeto o el path NO son v\u00e1lidos");
        }
        StringTokenizer st = new StringTokenizer(memberPath, ".");
        if (st.hasMoreTokens()) {
            try {
                Object currObj = obj;
                Class<?> currObjClass = currObj.getClass();
                Field currObjField = null;
                String[] currPathElem = null;
                do {
                    currPathElem = ReflectionUtils._parsePathElem(st.nextToken());
                    if (useAccesors) {
                        if ((currObj = ReflectionUtils.fieldValue(currObj, currPathElem[0], null, useAccesors)) != null) {
                            currObjClass = currObj.getClass();
                        }
                    } else {
                        try {
                            currObjField = ReflectionUtils.field(currObjClass, currPathElem[0], true);
                            if (currObjField != null && (currObj = currObjField.get(currObj)) != null) {
                                currObjClass = currObj.getClass();
                            }
                        }
                        catch (IllegalAccessException illAccEx) {
                            throw new ReflectionException("IllegalAccessException: Acceso ilegal al miembro '" + memberPath + "'", illAccEx);
                        }
                    }
                    if (currPathElem[1] == null) continue;
                    boolean found = false;
                    if (currObjClass.isArray()) {
                        if ((currObj = Array.get(currObj, Integer.parseInt(currPathElem[1]))) != null) {
                            currObjClass = currObj.getClass();
                        }
                        found = true;
                    } else {
                        Class<?>[] currObjInterfaces = currObjClass.getInterfaces();
                        if (currObjInterfaces != null) {
                            int i = 0;
                            while (i < currObjInterfaces.length) {
                                if (currObjInterfaces[i].equals(List.class)) {
                                    List list = (List)currObj;
                                    if ((currObj = list.get(Integer.parseInt(currPathElem[1]))) != null) {
                                        currObjClass = currObj.getClass();
                                    }
                                    found = true;
                                    break;
                                }
                                if (currObjInterfaces[i].equals(Map.class)) {
                                    Map map = (Map)currObj;
                                    if ((currObj = map.get(currPathElem[1])) != null) {
                                        currObjClass = currObj.getClass();
                                    }
                                    found = true;
                                    break;
                                }
                                ++i;
                            }
                        }
                    }
                    if (found) continue;
                    throw new ReflectionException("Se ha especificado que el miembro del path es un array, mapa o lista, sin embargo, su tipo es '" + currObjClass.getName() + "'");
                } while (st.hasMoreTokens());
                return currObj;
            }
            catch (ArrayIndexOutOfBoundsException aiobEx) {
                throw new ReflectionException("ArrayIndexOutOfBounds: El elemento del array no existe (" + memberPath + ")", aiobEx);
            }
        }
        return null;
    }

    private static String[] _parsePathElem(String pathElem) {
        String fieldName = pathElem;
        String ord = null;
        int p = -1;
        p = pathElem.indexOf("[");
        if (p > 0) {
            fieldName = pathElem.substring(0, p);
            ord = pathElem.substring(p + 1, pathElem.length() - 1);
        }
        String[] out = new String[]{fieldName, ord};
        return out;
    }

    public static String composeMethodSignature(String className, String methodName, Class<?>[] paramTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(className != null ? className : "[unknown class]");
        sb.append(".");
        sb.append(methodName != null ? methodName : "<constructor>");
        sb.append("(");
        sb.append(ArrayFormatter.instance().format(paramTypes));
        sb.append(")");
        return sb.toString();
    }

    public static String composeMethodSignature(Method m) {
        if (m == null) {
            return "<metodo nulo>";
        }
        StringBuilder outSignature = new StringBuilder();
        outSignature.append(m.getReturnType().getName());
        outSignature.append(" ");
        outSignature.append(m.getName());
        outSignature.append('(');
        Class<?>[] paramTypes = m.getParameterTypes();
        if (paramTypes != null) {
            int i = 0;
            while (i < paramTypes.length) {
                outSignature.append(paramTypes[i].getName());
                outSignature.append(" param");
                outSignature.append(i);
                if (i < paramTypes.length - 1) {
                    outSignature.append(',');
                }
                ++i;
            }
        }
        outSignature.append(')');
        Class<?>[] thrownTypes = m.getExceptionTypes();
        if (thrownTypes != null) {
            outSignature.append(" throws ");
            int i = 0;
            while (i < thrownTypes.length) {
                outSignature.append(thrownTypes[i].getName());
                if (i < thrownTypes.length - 1) {
                    outSignature.append(',');
                }
                ++i;
            }
        }
        outSignature.append(';');
        return outSignature.toString();
    }

    public static String composeClassMethodsSignatures(Class<?> type) {
        if (type == null) {
            return "<La definicion de la clase es nula>";
        }
        StringBuilder strDebug = new StringBuilder();
        Method[] methods = ReflectionUtils.allMethods(type);
        if (methods != null) {
            int i = 0;
            while (i < methods.length) {
                strDebug.append(methods[i].getDeclaringClass().getName());
                strDebug.append(" > ");
                strDebug.append(ReflectionUtils.composeMethodSignature(methods[i]));
                ++i;
            }
        } else {
            strDebug.append("<La clase ");
            strDebug.append(type);
            strDebug.append(" NO tiene m\u00e9todos definidos>");
        }
        return strDebug.toString();
    }

    public static class FieldAnnotated<A extends Annotation> {
        private final Field _field;
        private final A _annotation;

        public Field getField() {
            return this._field;
        }

        public A getAnnotation() {
            return this._annotation;
        }

        @ConstructorProperties(value={"_field", "_annotation"})
        public FieldAnnotated(Field _field, A _annotation) {
            this._field = _field;
            this._annotation = _annotation;
        }
    }

    private static class SetAccessibleAction
    implements PrivilegedAction<Void> {
        private final AccessibleObject _obj;
        private final boolean _accessible;

        SetAccessibleAction(AccessibleObject o, boolean accessible) {
            this._obj = o;
            this._accessible = accessible;
        }

        @Override
        public Void run() {
            this._obj.setAccessible(this._accessible);
            return null;
        }
    }
}

