/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import r01f.exceptions.EnrichedExceptionCustomizationsInterfaces;
import r01f.exceptions.EnrichedRuntimeException;
import r01f.reflection.ReflectionUtils;
import r01f.util.types.Strings;

public class ReflectionException
extends EnrichedRuntimeException {
    private static final long serialVersionUID = -3758897550813211878L;
    private String _class;
    private String _method;
    private String _field;

    public ReflectionException() {
    }

    public ReflectionException(String msg) {
        super(msg);
    }

    public ReflectionException(Throwable otherEx) {
        super(otherEx);
        this._subClass(otherEx);
    }

    public ReflectionException(String msg, Throwable otherEx) {
        super(msg, otherEx);
        this._subClass(otherEx);
    }

    public EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsWriter<ReflectionException, ReflectionExceptionSubTypes> customized() {
        return super.customized();
    }

    public EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsReader<ReflectionException, ReflectionExceptionSubTypes> customizations() {
        return super.customizations();
    }

    public ReflectionException inType(String className) {
        this._class = className;
        return this;
    }

    public ReflectionException inType(Object obj) {
        return this.inType(obj.getClass().getName());
    }

    public ReflectionException inField(String fieldName) {
        this._field = fieldName;
        return this;
    }

    public ReflectionException inField(Field field) {
        return this.inField(field.getName());
    }

    public ReflectionException inMethod(String methodName, Class<?> ... paramTypes) {
        this._method = ReflectionUtils.composeMethodSignature(this._class, methodName, paramTypes);
        return this;
    }

    public ReflectionException inMethod(Method method, Object ... params) {
        String methodName = method.getName();
        Class[] paramTypes = null;
        if (params != null) {
            paramTypes = new Class[params.length];
            int i = 0;
            Object[] objectArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                paramTypes[i++] = o.getClass();
                ++n2;
            }
        }
        return this.inMethod(methodName, paramTypes);
    }

    public ReflectionException inConstructor(Class<?> ... paramTypes) {
        return this.inMethod((String)null, paramTypes);
    }

    @Override
    public Throwable getCause() {
        boolean isInvocationTargetEx;
        Throwable cause = super.getCause();
        boolean bl = isInvocationTargetEx = cause != null ? ReflectionUtils.isSameClassAs(cause.getClass(), InvocationTargetException.class) : false;
        if (isInvocationTargetEx) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        return super.getCause();
    }

    @Override
    public String getMessage() {
        String msg = null;
        if (this.isClassNotFoundException()) {
            msg = Strings.create().add((CharSequence)"No se ha podido cargar la clase ").add((CharSequence)(this._class != null ? this._class : "unknown")).add((CharSequence)": NO existe una clase con este nombre o bien NO se encuentra en el classPath.").add((CharSequence)"; ").add((CharSequence)super.getMessage()).asString();
        } else if (this.isNoMethodException()) {
            msg = Strings.create().add((CharSequence)"No se ha podido encontrar el metodo ").add((CharSequence)(this._method != null ? this._method : "unknown")).add((CharSequence)" de la clase ").add((CharSequence)(this._class != null ? this._class : "unknown")).add((CharSequence)": NO existe un m\u00e9todo con ese nombre y esos parametros en la clase.").add((CharSequence)"; ").add((CharSequence)super.getMessage()).asString();
        } else if (this.isNoConstructorException()) {
            msg = Strings.create().add((CharSequence)"No se ha podido encontrar el constructor ").add((CharSequence)(this._method != null ? this._method : "unknown")).add((CharSequence)" de la clase ").add((CharSequence)(this._class != null ? this._class : "unknown")).add((CharSequence)": NO existe un constructor con ese nombre y esos parametros en la clase.").add((CharSequence)"; ").add((CharSequence)super.getMessage()).asString();
        } else if (this.isIllegalArgumentException()) {
            msg = Strings.create().add((CharSequence)"Argumento ilegal al invocar el metodo ").add((CharSequence)(this._method != null ? this._method : "unknown")).add((CharSequence)" de la clase ").add((CharSequence)(this._class != null ? this._class : "unknown")).add((CharSequence)"; ").add((CharSequence)super.getMessage()).asString();
        } else if (this.isInstantiationException()) {
            msg = Strings.create().add((CharSequence)"No se ha podido invocar el metodo ").add((CharSequence)this._method).add((CharSequence)" de la clase ").add((CharSequence)(this._class != null ? this._class : "unknown")).add((CharSequence)"; ").add((CharSequence)super.getMessage()).asString();
        } else if (this.isNoFieldExcepton()) {
            msg = Strings.create().add((CharSequence)"No existe el miembro ").add((CharSequence)(this._field != null ? this._field : "unknown")).add((CharSequence)" en la clase ").add((CharSequence)(this._class != null ? this._class : "unknown")).add((CharSequence)"; ").add((CharSequence)super.getMessage()).asString();
        } else if (this.isSecurityException()) {
            msg = Strings.create().add((CharSequence)"Error de seguridad al acceder al ").add((CharSequence)(this._field != null ? " miembro " : "")).add((CharSequence)(this._field != null ? this._field : "")).add((CharSequence)(this._method != null ? " metodo " : "")).add((CharSequence)(this._method != null ? this._method : "")).add((CharSequence)" en la clase ").add((CharSequence)(this._class != null ? this._class : "unknown")).add((CharSequence)"; ").add((CharSequence)super.getMessage()).asString();
        } else if (this.isInvocationTargetException()) {
            msg = Strings.create().add((CharSequence)"Error al ejecutar el metodo ").add((CharSequence)(this._method != null ? this._method : "unknown")).add((CharSequence)" en la clase ").add((CharSequence)(this._class != null ? this._class : "unknown")).add((CharSequence)"; ").add((CharSequence)this.getCause().getMessage()).asString();
        } else if (this.isunknownSubClassException()) {
            msg = Strings.create().add((CharSequence)"Error desconocido de Reflection ").add((CharSequence)" en la clase ").add((CharSequence)(this._class != null ? this._class : "unknown")).add((CharSequence)(this._field != null ? "; miembro " : "")).add((CharSequence)(this._field != null ? this._field : "")).add((CharSequence)(this._method != null ? "; metodo " : "")).add((CharSequence)(this._method != null ? this._method : "")).add((CharSequence)"; ").add((CharSequence)this.getCause().getMessage()).asString();
        }
        return msg;
    }

    private void _subClass(Throwable th) {
        if (th instanceof ClassNotFoundException) {
            this.classNotFoundException();
        } else if (th instanceof NoSuchMethodException) {
            this.noMethodException();
        } else if (th instanceof NoSuchFieldException) {
            this.noFieldException();
        } else if (th instanceof SecurityException) {
            this.securityException();
        } else if (th instanceof InstantiationException) {
            this.instantiationException();
        } else if (th instanceof IllegalAccessException) {
            this.instantiationException();
        } else if (th instanceof IllegalArgumentException) {
            this.illegalArgumentException();
        } else if (th instanceof InvocationTargetException) {
            this.invocationTargetException();
        } else {
            this.unknownSubClassException();
        }
    }

    public ReflectionException classNotFoundException() {
        this.customized().subClass(ReflectionExceptionSubTypes.CLASS_NOT_FOUND);
        return this;
    }

    public boolean isClassNotFoundException() {
        return this.customizations().isSubClassOf(ReflectionExceptionSubTypes.CLASS_NOT_FOUND);
    }

    public ReflectionException noMethodException() {
        this.customized().subClass(ReflectionExceptionSubTypes.NO_METHOD);
        return this;
    }

    public boolean isNoConstructorException() {
        return this.customizations().isSubClassOf(ReflectionExceptionSubTypes.NO_CONSTRUCTOR);
    }

    public ReflectionException noConstructorException() {
        this.customized().subClass(ReflectionExceptionSubTypes.NO_CONSTRUCTOR);
        return this;
    }

    public boolean isNoMethodException() {
        return this.customizations().isSubClassOf(ReflectionExceptionSubTypes.NO_METHOD);
    }

    public ReflectionException noFieldException() {
        this.customized().subClass(ReflectionExceptionSubTypes.NO_FIELD);
        return this;
    }

    public boolean isNoFieldExcepton() {
        return this.customizations().isSubClassOf(ReflectionExceptionSubTypes.NO_FIELD);
    }

    public ReflectionException securityException() {
        this.customized().subClass(ReflectionExceptionSubTypes.SECURITY);
        return this;
    }

    public boolean isSecurityException() {
        return this.customizations().isSubClassOf(ReflectionExceptionSubTypes.SECURITY);
    }

    public ReflectionException illegalArgumentException() {
        this.customized().subClass(ReflectionExceptionSubTypes.ILLEGAL_ARGUMENT);
        return this;
    }

    public boolean isIllegalArgumentException() {
        return this.customizations().isSubClassOf(ReflectionExceptionSubTypes.ILLEGAL_ARGUMENT);
    }

    public ReflectionException instantiationException() {
        this.customized().subClass(ReflectionExceptionSubTypes.INSTANTIATION);
        return this;
    }

    public boolean isInstantiationException() {
        return this.customizations().isSubClassOf(ReflectionExceptionSubTypes.INSTANTIATION);
    }

    public ReflectionException invocationTargetException() {
        this.customized().subClass(ReflectionExceptionSubTypes.INVOCATION_TARGET);
        return this;
    }

    public boolean isInvocationTargetException() {
        return this.customizations().isSubClassOf(ReflectionExceptionSubTypes.INVOCATION_TARGET);
    }

    public ReflectionException unknownSubClassException() {
        this.customized().subClass(ReflectionExceptionSubTypes.UNKNOWN);
        return this;
    }

    public boolean isunknownSubClassException() {
        return this.customizations().isSubClassOf(ReflectionExceptionSubTypes.UNKNOWN);
    }

    static enum ReflectionExceptionSubTypes {
        CLASS_NOT_FOUND,
        NO_CONSTRUCTOR,
        NO_METHOD,
        NO_FIELD,
        SECURITY,
        ILLEGAL_ARGUMENT,
        INSTANTIATION,
        INVOCATION_TARGET,
        UNKNOWN;

    }
}

