/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import r01f.reflection.BeanInstanceReflection;
import r01f.reflection.FieldReflection;
import r01f.reflection.MethodInvokeReflection;
import r01f.reflection.ReflectionUtils;

public class BeanReflection {
    private Class<?> _beanType;
    private Class<?>[] _constructorArgsTypes;

    public BeanReflection(Class<?> beanClassDef) {
        this._beanType = beanClassDef;
    }

    public Class<?> getType() {
        return this._beanType;
    }

    public BeanReflection withConstructor(Class<?> ... constructorArgsTypes) {
        this._constructorArgsTypes = constructorArgsTypes;
        return this;
    }

    public BeanInstanceReflection load(Object ... constructorArgs) {
        Class[] theConstructorArgsTypes = null;
        Object[] theConstructorArgs = null;
        if (this._constructorArgsTypes == null || this._constructorArgsTypes.length == 0) {
            theConstructorArgsTypes = new Class[]{};
            theConstructorArgs = new Object[]{};
        } else {
            theConstructorArgsTypes = this._constructorArgsTypes;
            theConstructorArgs = constructorArgs;
        }
        Object theBean = ReflectionUtils.createInstanceOf(this._beanType, theConstructorArgsTypes, theConstructorArgs, true);
        return new BeanInstanceReflection(this._beanType, theBean);
    }

    public MethodInvokeReflection staticMethod(String methodName, Class<?> ... paramTypes) {
        Method method = ReflectionUtils.method(this._beanType, methodName, paramTypes);
        return new MethodInvokeReflection(this._beanType, null, method);
    }

    public FieldReflection staticField(String fieldName) {
        Field field = ReflectionUtils.field(this._beanType, fieldName, true);
        return new FieldReflection(this._beanType, null, field);
    }
}

