/*
 * Decompiled with CFR 0.152.
 */
package r01f.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import r01f.reflection.FieldAnnotatedReflection;
import r01f.reflection.FieldReflection;
import r01f.reflection.MethodInvokeReflection;
import r01f.reflection.ReflectionUtils;

public class BeanInstanceReflection {
    private Class<?> _beanType;
    private Object _bean;

    public BeanInstanceReflection(Class<?> beanType, Object bean) {
        this._beanType = beanType;
        this._bean = bean;
    }

    public MethodInvokeReflection method(String methodName) {
        Method method = ReflectionUtils.method(this._beanType, methodName, new Class[0]);
        return new MethodInvokeReflection(this._beanType, this._bean, method);
    }

    public MethodInvokeReflection method(String methodName, Class<?> ... paramTypes) {
        Method method = ReflectionUtils.method(this._beanType, methodName, paramTypes);
        return new MethodInvokeReflection(this._beanType, this._bean, method);
    }

    public MethodInvokeReflection method(Method method) {
        return new MethodInvokeReflection(this._beanType, this._bean, method);
    }

    public <T> T instance() {
        return (T)this._bean;
    }

    public FieldReflection field(String fieldName) {
        Field field = ReflectionUtils.field(this._beanType, fieldName, true);
        return new FieldReflection(this._beanType, this._bean, field);
    }

    public FieldReflection field(Field field) {
        return new FieldReflection(this._beanType, this._bean, field);
    }

    public FieldReflection[] fieldsOfType(Class<?> fieldType) {
        Field[] fields = ReflectionUtils.fieldsOfType(this._beanType, fieldType);
        FieldReflection[] outFields = new FieldReflection[fields.length];
        int i = 0;
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldReflection fr;
            Field f = fieldArray[n2];
            outFields[i] = fr = new FieldReflection(this._beanType, this._bean, f);
            ++i;
            ++n2;
        }
        return outFields;
    }

    public FieldAnnotatedReflection<? extends Annotation>[] fieldsAnnotatedWith(Class<? extends Annotation> annotationType) {
        ReflectionUtils.FieldAnnotated<? extends Annotation>[] fieldsAnnotated = ReflectionUtils.fieldsAnnotated(this._beanType, annotationType);
        FieldAnnotatedReflection[] outFields = null;
        if (fieldsAnnotated != null && fieldsAnnotated.length > 0) {
            outFields = new FieldAnnotatedReflection[fieldsAnnotated.length];
            int i = 0;
            ReflectionUtils.FieldAnnotated<? extends Annotation>[] fieldAnnotatedArray = fieldsAnnotated;
            int n = fieldsAnnotated.length;
            int n2 = 0;
            while (n2 < n) {
                ReflectionUtils.FieldAnnotated<? extends Annotation> fieldAnnotated = fieldAnnotatedArray[n2];
                FieldReflection fr = new FieldReflection(this._beanType, this._bean, fieldAnnotated.getField());
                Annotation an = fieldAnnotated.getAnnotation();
                outFields[i] = new FieldAnnotatedReflection<Annotation>(fr, an);
                ++i;
                ++n2;
            }
        }
        return outFields;
    }
}

