/*
 * Decompiled with CFR 0.152.
 */
package r01f.process;

public class TimeOutController {
    private TimeOutController() {
    }

    public static void execute(Thread task, long timeout) throws TimeoutException {
        task.start();
        try {
            task.join(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (task.isAlive()) {
            task.interrupt();
            throw new TimeoutException();
        }
    }

    public static void execute(Runnable task, long timeout) throws TimeoutException {
        Thread t = new Thread(task, "Timeout guard");
        t.setDaemon(true);
        TimeOutController.execute(t, timeout);
    }

    public static class TimeoutException
    extends Exception {
        private static final long serialVersionUID = 273515211929706600L;
    }
}

