/*
 * Decompiled with CFR 0.152.
 */
package r01f.marshalling.simple;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import r01f.encoding.TextEncoder;
import r01f.marshalling.MarshallerException;
import r01f.marshalling.MarshallerMappings;
import r01f.marshalling.simple.BeanMap;
import r01f.marshalling.simple.DataTypes;
import r01f.marshalling.simple.FieldMap;
import r01f.marshalling.simple.MappingReflectionUtils;
import r01f.marshalling.simple.SimpleMarshallerMappings;
import r01f.marshalling.simple.XMLBuilder;
import r01f.reflection.ReflectionException;
import r01f.util.types.Strings;
import r01f.util.types.collections.CollectionUtils;

class XMLFromObjsBuilder {
    private final SimpleMarshallerMappings _beanMappings;

    public XMLFromObjsBuilder(MarshallerMappings map) {
        this._beanMappings = (SimpleMarshallerMappings)map;
    }

    public String xmlFrom(Object obj, Charset xmlCharset, TextEncoder encoder) throws MarshallerException {
        BeanMap beanMap = this._beanMappings.getBeanMapFromClassName(obj.getClass().getName());
        XMLBuilder.XMLElement xml = this._generateXML(null, obj, beanMap);
        Charset theCharset = xmlCharset != null ? xmlCharset : Charset.defaultCharset();
        return Strings.of((CharSequence)xml.asText(encoder).toString()).encode(theCharset).asString();
    }

    private XMLBuilder.XMLElement _generateXML(String xmlElTag, Object inObj, BeanMap beanMap) throws MarshallerException {
        if (beanMap == null) {
            throw new MarshallerException("No se ha encontrado el mapeo para el bean " + inObj.getClass().getName() + ". Revisa el fichero de mapeo");
        }
        String fieldName = null;
        Object fieldValue = null;
        XMLBuilder.XMLElement xmlEl = XMLBuilder.XMLElement.create(xmlElTag != null ? xmlElTag : beanMap.getXmlMap().getNodeName());
        try {
            for (FieldMap currField : beanMap.getFields().values()) {
                String fieldValueStr;
                if (currField.isTranzient()) continue;
                if (currField.getXmlMap().isAttribute()) {
                    fieldName = currField.getName();
                    fieldValue = MappingReflectionUtils.getFieldValue(inObj, fieldName, beanMap.isUseAccessors());
                    String string = fieldValueStr = fieldValue != null ? MappingReflectionUtils.formatAsString(fieldValue, currField.getDataType()) : null;
                    if (fieldValueStr == null) continue;
                    xmlEl.addAttribute(currField.getXmlMap().getNodeName(), fieldValueStr);
                    continue;
                }
                fieldName = currField.getName();
                fieldValue = MappingReflectionUtils.getFieldValue(inObj, fieldName, beanMap.isUseAccessors());
                if (fieldValue == null) continue;
                if (currField.getDataType().isCollection()) {
                    Collection<?> colItems = MappingReflectionUtils.getCollectionElements(fieldValue);
                    if (CollectionUtils.isNullOrEmpty(colItems)) continue;
                    XMLBuilder.XMLElement colEnclosingXmlEl = null;
                    if (currField.getXmlMap().getNodeName().equals(beanMap.getXmlMap().getNodeName())) {
                        colEnclosingXmlEl = xmlEl;
                    } else {
                        colEnclosingXmlEl = XMLBuilder.XMLElement.create(currField.getXmlMap().getNodeName());
                        xmlEl.newChildElement(colEnclosingXmlEl);
                    }
                    int i = 0;
                    for (Object colItem : colItems) {
                        XMLBuilder.XMLElement colXmlEl = null;
                        Object colItemOjb = currField.getDataType().isMap() ? ((Map.Entry)colItem).getValue() : colItem;
                        DataTypes.DataType colItemObjDataType = currField.getDataType().asCollection().getElementsType();
                        if (MappingReflectionUtils.isSimple(colItemOjb)) {
                            String fieldValueStr2 = MappingReflectionUtils.formatAsString(colItemOjb, colItemObjDataType);
                            if (fieldValueStr2 != null) {
                                String tagName = currField.getXmlMap().getColElsNodeName();
                                if (currField.getDataType().isMap()) {
                                    tagName = tagName == null ? ((Map.Entry)colItem).getKey().toString() : String.valueOf(tagName) + (i + 1);
                                } else if (tagName == null) {
                                    tagName = "item" + (currField.getDataType().isMap() ? Integer.valueOf(i) : "");
                                }
                                colXmlEl = XMLBuilder.XMLElement.create(tagName).cdata(currField.getXmlMap().isCdata()).withText(fieldValueStr2);
                            }
                        } else if (colItemObjDataType.isObject()) {
                            BeanMap colItemObjBeanMap = colItemObjDataType.getBeanMap();
                            if (colItemObjBeanMap == null) {
                                colItemObjBeanMap = this._beanMappings.getBeanMapFromClassName(colItemOjb.getClass().getName());
                            }
                            if (colItemObjBeanMap == null) {
                                throw new MarshallerException("NO se encuentra el mapeo de la clase " + colItemOjb.getClass().getName() + " especificado como elemento de la colecci\u00f3n " + currField.getName() + " en la clase " + currField.getDeclaringBeanMap().getType() + ". Revisa el documento de mapeo");
                            }
                            colXmlEl = this._generateXML(currField.getXmlMap().getColElsNodeName(), colItemOjb, colItemObjBeanMap);
                        }
                        if (colXmlEl != null && !colXmlEl.isEmpty()) {
                            colEnclosingXmlEl.newChildElement(colXmlEl);
                        }
                        ++i;
                    }
                    continue;
                }
                fieldValueStr = MappingReflectionUtils.formatAsString(fieldValue, currField.getDataType());
                if (fieldValueStr != null) {
                    if (currField.getXmlMap().getNodeName().equals(beanMap.getXmlMap().getNodeName())) {
                        xmlEl.withText(fieldValueStr);
                        continue;
                    }
                    XMLBuilder.XMLElement beanXmlEl = XMLBuilder.XMLElement.create(currField.getXmlMap().getNodeName()).cdata(currField.getXmlMap().isCdata()).withText(fieldValueStr);
                    xmlEl.newChildElement(beanXmlEl);
                    continue;
                }
                BeanMap elBeanMap = this._beanMappings.getBeanMapFromClassName(fieldValue.getClass().getName());
                if (elBeanMap == null) {
                    throw new MarshallerException("NO se encuentra el mapeo de la clase " + fieldValue.getClass().getName() + ". Revisa el documento de mapeo");
                }
                XMLBuilder.XMLElement beanXmlEl = this._generateXML(currField.getXmlMap().getNodeName(), fieldValue, elBeanMap);
                if (beanXmlEl.isEmpty()) continue;
                xmlEl.newChildElement(beanXmlEl);
            }
        }
        catch (ReflectionException refEx) {
            throw new MarshallerException("Error al acceder al valor de la variable miembro '" + fieldName + "' del bean '" + beanMap.getType() + "'", refEx);
        }
        return xmlEl;
    }
}

