/*
 * Decompiled with CFR 0.152.
 */
package r01f.marshalling.simple;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import r01f.encoding.TextEncoder;

class XMLBuilder {
    XMLBuilder() {
    }

    static class XMLAttribute {
        private String _name;
        private String _value;

        public boolean isEmpty() {
            return this._value == null;
        }

        public StringBuilder asText(TextEncoder textEncoder) {
            StringBuilder attr = new StringBuilder("");
            if (this._name != null) {
                attr.append(this._name).append("='").append(textEncoder != null ? textEncoder.encode(this._value) : this._value).append("'");
            }
            return attr;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String _name) {
            this._name = _name;
        }

        public String getValue() {
            return this._value;
        }

        public void setValue(String _value) {
            this._value = _value;
        }

        public XMLAttribute() {
        }

        @ConstructorProperties(value={"_name", "_value"})
        public XMLAttribute(String _name, String _value) {
            this._name = _name;
            this._value = _value;
        }
    }

    static class XMLElement {
        private XMLElement _parentNode;
        private String _tag;
        private String _text;
        private boolean _isCDATA;
        private List<XMLElement> _childElements;
        private List<XMLAttribute> _attributes;

        public static XMLElement create(String tag) {
            XMLElement outEl = new XMLElement();
            outEl.setTag(tag);
            return outEl;
        }

        public XMLElement withText(String nodeText) {
            this.setText(nodeText);
            return this;
        }

        public XMLElement cdata(boolean isCDATA) {
            this.setCDATA(isCDATA);
            return this;
        }

        public XMLElement addAttribute(String attrName, String attrValue) {
            XMLAttribute newAttr = new XMLAttribute(attrName, attrValue);
            if (this._attributes == null) {
                this._attributes = new ArrayList<XMLAttribute>();
            }
            this._attributes.add(newAttr);
            return this;
        }

        public XMLElement newChildElement(XMLElement childElement) {
            if (this._childElements == null) {
                this._childElements = new ArrayList<XMLElement>();
            }
            this._childElements.add(childElement);
            return childElement;
        }

        public boolean isEmpty() {
            boolean empty = this._text == null && this._childElements == null && this._attributes == null;
            return empty;
        }

        public StringBuilder asText(TextEncoder textEncoder) {
            int size = this._attributes != null && this._attributes.size() > 0 ? this._attributes.size() * 128 : 32;
            StringBuilder sb = new StringBuilder(size += this._childElements != null && this._childElements.size() > 0 ? this._childElements.size() * 256 : 32);
            sb.append("<").append(this._tag);
            if (this._attributes != null) {
                for (XMLAttribute attr : this._attributes) {
                    sb.append(" ").append((CharSequence)attr.asText(textEncoder));
                }
            }
            if (this._text == null && this._childElements == null) {
                sb.append("/>");
            } else {
                sb.append(">");
                if (this._isCDATA) {
                    sb.append("<![CDATA[");
                }
                if (this._text != null) {
                    sb.append(textEncoder != null ? textEncoder.encode(this._text) : this._text);
                }
                if (this._childElements != null) {
                    for (XMLElement el : this._childElements) {
                        sb.append((CharSequence)el.asText(textEncoder));
                    }
                }
                if (this._isCDATA) {
                    sb.append("]]>");
                }
                sb.append("</").append(this._tag).append(">");
            }
            return sb;
        }

        public XMLElement getParentNode() {
            return this._parentNode;
        }

        public void setParentNode(XMLElement _parentNode) {
            this._parentNode = _parentNode;
        }

        public String getTag() {
            return this._tag;
        }

        public void setTag(String _tag) {
            this._tag = _tag;
        }

        public String getText() {
            return this._text;
        }

        public void setText(String _text) {
            this._text = _text;
        }

        public boolean isCDATA() {
            return this._isCDATA;
        }

        public void setCDATA(boolean _isCDATA) {
            this._isCDATA = _isCDATA;
        }

        public List<XMLElement> getChildElements() {
            return this._childElements;
        }

        public void setChildElements(List<XMLElement> _childElements) {
            this._childElements = _childElements;
        }

        public List<XMLAttribute> getAttributes() {
            return this._attributes;
        }

        public void setAttributes(List<XMLAttribute> _attributes) {
            this._attributes = _attributes;
        }
    }
}

