/*
 * Decompiled with CFR 0.152.
 */
package r01f.marshalling.simple;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import r01f.marshalling.MarshallerException;
import r01f.marshalling.annotations.OidField;
import r01f.marshalling.annotations.XmlCDATA;
import r01f.marshalling.simple.BeanMap;
import r01f.marshalling.simple.DataTypes;
import r01f.marshalling.simple.FieldMap;
import r01f.marshalling.simple.SimpleMarshallerMappings;
import r01f.reflection.ReflectionUtils;
import r01f.util.types.collections.CollectionUtils;

class SimpleMarshallerMappingsFromAnnotationsLoader {
    private Map<String, BeanMap> _loadedBeans = new HashMap<String, BeanMap>();

    public SimpleMarshallerMappingsFromAnnotationsLoader(Class<?> ... types) throws MarshallerException {
        if (types == null) {
            return;
        }
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            this._beanMapFromBeanAnnotations(type);
            ++n2;
        }
        SimpleMarshallerMappings.connectBeanMappings(this._loadedBeans);
    }

    private void _beanMapFromBeanAnnotations(Class<?> type) throws MarshallerException {
        ReflectionUtils.FieldAnnotated<XmlElementWrapper>[] xmlWrappedFields;
        ReflectionUtils.FieldAnnotated<XmlElement>[] xmlElFields;
        ReflectionUtils.FieldAnnotated<XmlAttribute>[] xmlAttrFields;
        int n;
        ReflectionUtils.FieldAnnotated<XmlValue>[] xmlValueFields;
        BeanMap beanMap = new BeanMap(type.getName());
        XmlRootElement rootAnnot = ReflectionUtils.typeAnnotation(type, XmlRootElement.class);
        String beanNodeName = SimpleMarshallerMappingsFromAnnotationsLoader._nodeNameFromAnnotation(rootAnnot != null ? rootAnnot.name() : null, ReflectionUtils.classNameFromClassName(type.getName()));
        beanMap.getXmlMap().setNodeName(beanNodeName);
        this._loadedBeans.put(type.getName(), beanMap);
        XmlAccessorType accessorType = ReflectionUtils.typeAnnotation(type, XmlAccessorType.class);
        if (accessorType != null) {
            beanMap.setUseAccessors(accessorType.value() == XmlAccessType.PROPERTY);
        }
        if ((xmlValueFields = ReflectionUtils.fieldsAnnotated(type, XmlValue.class)) != null) {
            ReflectionUtils.FieldAnnotated<XmlValue>[] fieldAnnotatedArray = xmlValueFields;
            n = xmlValueFields.length;
            int n2 = 0;
            while (n2 < n) {
                ReflectionUtils.FieldAnnotated<XmlValue> fAnnot = fieldAnnotatedArray[n2];
                if (fAnnot.getField().getAnnotation(XmlTransient.class) != null) {
                    throw new MarshallerException("La anotacion @XmlTransient NO puede aparecer junto a @XmlValue. Revisa el campo " + fAnnot.getField().getName() + " de la clase " + type.getName());
                }
                if (fAnnot.getField().getAnnotation(XmlAttribute.class) != null || fAnnot.getField().getAnnotation(XmlElement.class) != null || fAnnot.getField().getAnnotation(XmlElementWrapper.class) != null) {
                    throw new MarshallerException("La anotaci\u00f3n @XmlValue NO puede aparecer junto a @XmlAttribute, @XmlElement o @XmlElementWrapper. Revisa el campo " + fAnnot.getField().getName() + " de la clase " + type.getName());
                }
                FieldMap fieldMap = SimpleMarshallerMappingsFromAnnotationsLoader._fieldMapFromField(type, fAnnot.getField());
                fieldMap.getXmlMap().setAttribute(false);
                String fieldNodeName = beanNodeName;
                fieldMap.getXmlMap().setNodeName(fieldNodeName);
                beanMap.addField(fieldMap);
                ++n2;
            }
        }
        if ((xmlAttrFields = ReflectionUtils.fieldsAnnotated(type, XmlAttribute.class)) != null) {
            ReflectionUtils.FieldAnnotated<XmlAttribute>[] fieldAnnotatedArray = xmlAttrFields;
            int n3 = xmlAttrFields.length;
            n = 0;
            while (n < n3) {
                ReflectionUtils.FieldAnnotated<XmlAttribute> fAnnot = fieldAnnotatedArray[n];
                if (fAnnot.getField().getAnnotation(XmlTransient.class) != null) {
                    throw new MarshallerException("La anotacion @XmlTransient NO puede aparecer junto a @XmlAttribute. Revisa el campo " + fAnnot.getField().getName() + " de la clase " + type.getName());
                }
                FieldMap fieldMap = SimpleMarshallerMappingsFromAnnotationsLoader._fieldMapFromField(type, fAnnot.getField());
                fieldMap.getXmlMap().setAttribute(true);
                XmlAttribute xmlAttrAnnot = fAnnot.getAnnotation();
                String fieldNodeName = SimpleMarshallerMappingsFromAnnotationsLoader._nodeNameFromAnnotation(xmlAttrAnnot != null ? xmlAttrAnnot.name() : null, fieldMap.getName());
                fieldMap.getXmlMap().setNodeName(fieldNodeName);
                beanMap.addField(fieldMap);
                ++n;
            }
        }
        if ((xmlElFields = ReflectionUtils.fieldsAnnotated(type, XmlElement.class)) != null) {
            ReflectionUtils.FieldAnnotated<XmlElement>[] fieldAnnotatedArray = xmlElFields;
            int n4 = xmlElFields.length;
            int n5 = 0;
            while (n5 < n4) {
                ReflectionUtils.FieldAnnotated<XmlElement> fAnnot = fieldAnnotatedArray[n5];
                if (fAnnot.getField().getAnnotation(XmlTransient.class) != null) {
                    throw new MarshallerException("La anotacion @XmlTransient NO puede aparecer junto a @XmlElement. Revisa el campo " + fAnnot.getField().getName() + " de la clase " + type.getName());
                }
                FieldMap fieldMap = SimpleMarshallerMappingsFromAnnotationsLoader._fieldMapFromField(type, fAnnot.getField());
                fieldMap.getXmlMap().setAttribute(false);
                XmlElement xmlElAnnot = fAnnot.getAnnotation();
                if (fieldMap.getDataType().isCollection()) {
                    XmlElementWrapper xmlElWrapAnnot = fAnnot.getField().getAnnotation(XmlElementWrapper.class);
                    String wrapperNodeName = xmlElWrapAnnot != null ? xmlElWrapAnnot.name() : beanNodeName;
                    String elementsNodeName = SimpleMarshallerMappingsFromAnnotationsLoader._nodeNameFromAnnotation(xmlElAnnot != null ? xmlElAnnot.name() : null, fieldMap.getName());
                    fieldMap.getXmlMap().setNodeName(wrapperNodeName);
                    fieldMap.getXmlMap().setColElsNodeName(elementsNodeName);
                } else {
                    String fieldNodeName = SimpleMarshallerMappingsFromAnnotationsLoader._nodeNameFromAnnotation(xmlElAnnot != null ? xmlElAnnot.name() : null, fieldMap.getName());
                    fieldMap.getXmlMap().setNodeName(fieldNodeName);
                }
                beanMap.addField(fieldMap);
                this._recursiveMapBean(fieldMap.getDataType());
                ++n5;
            }
        }
        if ((xmlWrappedFields = ReflectionUtils.fieldsAnnotated(type, XmlElementWrapper.class)) != null) {
            ReflectionUtils.FieldAnnotated<XmlElementWrapper>[] fieldAnnotatedArray = xmlWrappedFields;
            int n6 = xmlWrappedFields.length;
            int n7 = 0;
            while (n7 < n6) {
                ReflectionUtils.FieldAnnotated<XmlElementWrapper> fAnnot = fieldAnnotatedArray[n7];
                if (fAnnot.getField().getAnnotation(XmlTransient.class) != null) {
                    throw new MarshallerException("La anotacion @XmlTransient NO puede aparecer junto a @XmlElementWrapper. Revisa el campo " + fAnnot.getField().getName() + " de la clase " + type.getName());
                }
                String fieldName = SimpleMarshallerMappingsFromAnnotationsLoader._fieldName(fAnnot.getField());
                if (beanMap.getField(fieldName) == null) {
                    FieldMap fieldMap = SimpleMarshallerMappingsFromAnnotationsLoader._fieldMapFromField(type, fAnnot.getField());
                    fieldMap.getXmlMap().setAttribute(false);
                    XmlElementWrapper xmlElWrapAnnot = fAnnot.getAnnotation();
                    String wrapperNodeName = SimpleMarshallerMappingsFromAnnotationsLoader._nodeNameFromAnnotation(xmlElWrapAnnot != null ? xmlElWrapAnnot.name() : null, fieldMap.getName());
                    fieldMap.getXmlMap().setNodeName(wrapperNodeName);
                    beanMap.addField(fieldMap);
                    this._recursiveMapBean(fieldMap.getDataType());
                }
                ++n7;
            }
        }
    }

    private void _recursiveMapBean(DataTypes.DataType dataType) throws MarshallerException {
        String childTypeName;
        DataTypes.DataType childDataType = null;
        if (dataType.isObject()) {
            childDataType = dataType;
        } else if (dataType.isCollection() && dataType.asCollection().getElementsType().isObject()) {
            childDataType = dataType.asCollection().getElementsType();
        }
        if (childDataType != null && childDataType.asObject().isKnownType() && !this._loadedBeans.containsKey(childTypeName = childDataType.getName())) {
            this._beanMapFromBeanAnnotations(ReflectionUtils.typeFromClassName(childTypeName));
        }
    }

    private static FieldMap _fieldMapFromField(Class<?> type, Field field) {
        OidField oidFieldAnnot = field.getAnnotation(OidField.class);
        boolean isOid = oidFieldAnnot != null;
        FieldMap fieldMap = new FieldMap(SimpleMarshallerMappingsFromAnnotationsLoader._fieldName(field), SimpleMarshallerMappingsFromAnnotationsLoader._dataTypeFromType(field), isOid);
        if (!fieldMap.getXmlMap().isAttribute()) {
            XmlCDATA xmlCDATAFieldAnnot = field.getAnnotation(XmlCDATA.class);
            boolean isCDATA = xmlCDATAFieldAnnot != null;
            fieldMap.getXmlMap().setCdata(isCDATA);
        }
        return fieldMap;
    }

    private static String _nodeNameFromAnnotation(String name, String defaultName) {
        String outName = null;
        outName = name != null && !name.equals("##default") ? name : defaultName.replaceAll("\\$", "_");
        return outName;
    }

    private static DataTypes.DataType _dataTypeFromType(Field field) {
        String dataTypeDesc = null;
        if (CollectionUtils.isMap(field.getType())) {
            Class<?>[] keyAndValueComponentTypes = ReflectionUtils.mapFieldKeyValueComponentTypes(field);
            dataTypeDesc = "java.util.Map(" + keyAndValueComponentTypes[0].getName() + "," + keyAndValueComponentTypes[1].getName() + ")";
        } else if (CollectionUtils.isCollection(field.getType())) {
            Class<?> componentType = ReflectionUtils.collectionFieldComponentType(field);
            dataTypeDesc = "java.util.List(" + componentType.getName() + ")";
        } else {
            dataTypeDesc = CollectionUtils.isArray(field.getType()) ? ReflectionUtils.collectionFieldComponentType(field) + "[]" : (field.getType().isEnum() ? "Enum(" + field.getType().getName() + ")" : field.getType().getName());
        }
        DataTypes.DataType outDataType = DataTypes.DataType.create(dataTypeDesc);
        if (outDataType.isCollection()) {
            DataTypes.DataType colElsType = DataTypes.DataType.create(outDataType.asCollection().getElementsTypeName());
            outDataType.asCollection().setElementsType(colElsType);
        }
        return outDataType;
    }

    private static String _fieldName(Field f) {
        String prefix = "_";
        String outFieldName = f.getName();
        if (f.getName().startsWith(prefix)) {
            outFieldName = f.getName().substring(prefix.length());
        }
        return outFieldName;
    }

    public Map<String, BeanMap> getLoadedBeans() {
        return this._loadedBeans;
    }
}

