/*
 * Decompiled with CFR 0.152.
 */
package r01f.marshalling.simple;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import r01f.marshalling.MarshallerException;
import r01f.marshalling.MarshallerMappings;
import r01f.marshalling.simple.BeanMap;
import r01f.marshalling.simple.DataTypes;
import r01f.marshalling.simple.FieldMap;
import r01f.marshalling.simple.MarshallerMappingsFromXMLLoader;
import r01f.marshalling.simple.SimpleMarshallerMappingsFromAnnotationsLoader;
import r01f.util.types.Strings;
import r01f.util.types.collections.CollectionUtils;

public class SimpleMarshallerMappings
implements MarshallerMappings {
    private static final Logger log = LoggerFactory.getLogger(SimpleMarshallerMappings.class);
    private Map<String, BeanMap> _beanMappingsByType = new HashMap<String, BeanMap>(200, 0.3f);
    private Map<String, BeanMap> _beanMappingsByEnclosingXmlElement = new HashMap<String, BeanMap>(200, 0.3f);

    public BeanMap getBeanMapFromClassName(String beanName) {
        if (this._beanMappingsByType == null) {
            return null;
        }
        return this._beanMappingsByType.get(beanName);
    }

    public BeanMap getBeanMapFromXmlTag(String tagName) {
        BeanMap outBean = this._beanMappingsByEnclosingXmlElement.get(tagName);
        if (outBean != null) {
            return outBean;
        }
        for (BeanMap currBean : this._beanMappingsByType.values()) {
            if (!currBean.getXmlMap().getNodeName().equals(tagName)) continue;
            outBean = currBean;
            break;
        }
        if (outBean != null) {
            this._beanMappingsByEnclosingXmlElement.put(tagName, outBean);
        }
        return outBean;
    }

    @Override
    public void loadFromAnnotatedClasses(Class<?> ... annotatedTypes) throws MarshallerException {
        SimpleMarshallerMappingsFromAnnotationsLoader annotLoader = new SimpleMarshallerMappingsFromAnnotationsLoader(annotatedTypes);
        Map<String, BeanMap> mappings = annotLoader.getLoadedBeans();
        this._cacheBeansMappings(mappings);
    }

    @Override
    public void loadFromMappingDefFiles(String filePath) throws MarshallerException {
        File mapFile = new File(filePath);
        this.loadFromMappingDefFiles(mapFile);
    }

    @Override
    public void loadFromMappingDef(InputStream mapIS) throws MarshallerException {
        Map<String, BeanMap> mappings = SimpleMarshallerMappings._loadFromXML(mapIS, null);
        this._cacheBeansMappings(mappings);
    }

    public void loadFromMappingDefFiles(File mapFile) throws MarshallerException {
        if (mapFile != null) {
            try {
                FileInputStream fis = new FileInputStream(mapFile);
                try {
                    Map<String, BeanMap> mappings = SimpleMarshallerMappings._loadFromXML(fis, null);
                    this._cacheBeansMappings(mappings);
                }
                finally {
                    if (Collections.singletonList(fis).get(0) != null) {
                        fis.close();
                    }
                }
            }
            catch (FileNotFoundException fnfEx) {
                throw new MarshallerException(fnfEx.getMessage(), fnfEx);
            }
            catch (IOException ioEx) {
                throw new MarshallerException(ioEx);
            }
        }
    }

    private static Map<String, BeanMap> _loadFromXML(InputStream mapXmlIS, Charset charset) throws MarshallerException {
        Map<String, BeanMap> outBeansMappingDef = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            MarshallerMappingsFromXMLLoader loader = new MarshallerMappingsFromXMLLoader();
            Charset theCharset = charset != null ? charset : Charset.defaultCharset();
            InputStreamReader isr = new InputStreamReader(mapXmlIS, theCharset);
            try {
                InputSource is = new InputSource(isr);
                saxParser.parse(is, (DefaultHandler)loader);
                outBeansMappingDef = loader.getLoadedBeans();
            }
            finally {
                if (Collections.singletonList(isr).get(0) != null) {
                    isr.close();
                }
            }
        }
        catch (SAXException saxEx) {
            Throwable cause = saxEx.getCause();
            if (cause instanceof MarshallerException) {
                throw (MarshallerException)cause;
            }
            throw new MarshallerException("Error en el parseo del fichero de mapeo: " + saxEx.toString(), saxEx);
        }
        catch (ParserConfigurationException pcEx) {
            throw new MarshallerException("Error en la configuraci\u00f3n del parser: " + pcEx.toString(), pcEx);
        }
        catch (IOException ioEx) {
            throw new MarshallerException("Error de IO al cargar el xml de mapeo: " + ioEx.toString(), ioEx);
        }
        return outBeansMappingDef;
    }

    @Override
    public String debugInfo() {
        if (this._beanMappingsByType == null) {
            return "NO beans in XOMap";
        }
        StringBuilder sb = new StringBuilder(this._beanMappingsByType.size() * 200);
        for (BeanMap currBean : this._beanMappingsByType.values()) {
            sb.append(currBean.debugInfo());
        }
        sb.append("\r\n\r\n[[[[----XML---]]]]\r\n");
        for (BeanMap currBean : this._beanMappingsByType.values()) {
            sb.append(currBean.toXml()).append("\r\n");
        }
        return sb.toString();
    }

    private void _cacheBeansMappings(Map<String, BeanMap> loadedBeans) {
        if (loadedBeans != null && loadedBeans.size() > 0) {
            this._beanMappingsByType.putAll(loadedBeans);
            if (log.isTraceEnabled()) {
                StringBuilder dbgInfo = new StringBuilder(this._beanMappingsByType.size() * 500);
                for (BeanMap bm : this._beanMappingsByType.values()) {
                    dbgInfo.append(bm.debugInfo());
                }
                StringBuilder dbgXml = new StringBuilder(this._beanMappingsByType.size() * 500);
                for (BeanMap bm : this._beanMappingsByType.values()) {
                    dbgXml.append(bm.toXml()).append("\r\n");
                }
                log.trace("Definici\u00f3n de mapeo para el proceso de marshalling/unmarshalling: {}\r\n{}\r\n", (Object)dbgInfo, (Object)dbgXml);
            }
        }
    }

    static void connectBeanMappings(Map<String, BeanMap> beansMappings) throws MarshallerException {
        for (BeanMap beanMap : beansMappings.values()) {
            if (CollectionUtils.isNullOrEmpty(beanMap.getFields())) continue;
            for (FieldMap fieldMap : beanMap.getFields().values()) {
                DataTypes.DataType dataType;
                String keyType;
                Pattern p;
                Matcher m;
                if (fieldMap.getDataType().isObject() && fieldMap.getDataType().asObject().isKnownType()) {
                    BeanMap fieldObjBeanMap = beansMappings.get(fieldMap.getDataType().getName());
                    if (fieldObjBeanMap == null) {
                        throw new MarshallerException(new MarshallerException("El miembro " + fieldMap.getName() + " es un tipo complejo [" + fieldMap.getDataType().getName() + "] sin embargo NO se ha podido cargar la definici\u00f3n del tipo"));
                    }
                    fieldMap.getDataType().setBeanMap(fieldObjBeanMap);
                    continue;
                }
                if (!fieldMap.getDataType().isCollection()) continue;
                String colElsTypeName = fieldMap.getDataType().asCollection().getElementsTypeName();
                DataTypes.DataType colElsType = DataTypes.DataType.create(colElsTypeName);
                if (!colElsType.isSimple()) {
                    if (colElsType.getType() == DataTypes.DataTypeEnum.OBJECT && !DataTypes.DataTypeEnum.OBJECT.canBeFromTypeName(colElsTypeName)) {
                        BeanMap colElsBeanMap = beansMappings.get(colElsTypeName);
                        if (colElsBeanMap == null) {
                            throw new MarshallerException("El miembro " + fieldMap.getName() + " es un tipo colecci\u00f3n [" + colElsType.getName() + "] sin embargo NO se ha definido este tipo");
                        }
                        colElsType.setBeanMap(colElsBeanMap);
                    } else {
                        colElsType.setBeanMap(null);
                    }
                }
                fieldMap.getDataType().asCollection().setElementsType(colElsType);
                if (colElsType.getType() != DataTypes.DataTypeEnum.STRING && fieldMap.getXmlMap().isCdata()) {
                    throw new MarshallerException(new MarshallerException("Si un miembro es una coleccion y sus elementos NO son de tipo String, el miembro NO puede ser CDATA. Revisa el miembro " + fieldMap.getName() + " del bean " + fieldMap.getDeclaringBeanMap().getType()));
                }
                if (!fieldMap.getDataType().isMap() || fieldMap.getDataType().asCollection().getElementsType() != null || !(m = (p = Pattern.compile("[a-zA-Z]+(?:\\(([^,]+,[^,]+)\\))?")).matcher(fieldMap.getDataType().getName())).find() || (keyType = Strings.of((CharSequence)m.group(1)).splitter(",").group(2).asString()) == null || (dataType = DataTypes.DataType.create(keyType)).getType() == DataTypes.DataTypeEnum.STRING) continue;
                throw new MarshallerException(new MarshallerException("Si un miembro es de tipo Map y los values del map son tipos SIMPLES (ej: Map<String,Long> o Map<String,String>), la clave TIENE que ser de tipo String (y sera SIEMPRE el nombre del tag que 'engloba' el value). Revisa el miembro " + fieldMap.getName() + " del bean " + fieldMap.getDeclaringBeanMap().getType()));
            }
            beanMap.initIndexes();
        }
    }
}

