/*
 * Decompiled with CFR 0.152.
 */
package r01f.marshalling.simple;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.w3c.dom.Node;
import r01f.encoding.TextEncoder;
import r01f.marshalling.Marshaller;
import r01f.marshalling.MarshallerException;
import r01f.marshalling.MarshallerMappings;
import r01f.marshalling.simple.ObjsFromXMLBuilder;
import r01f.marshalling.simple.XMLFromObjsBuilder;

abstract class SimpleMarshallerBase
implements Marshaller {
    MarshallerMappings _mappings;
    private Charset _charSet;
    private TextEncoder _textEncoder;

    SimpleMarshallerBase() {
    }

    @Override
    public Marshaller addBeans(String mapFilesPath) throws MarshallerException {
        this._mappings.loadFromMappingDefFiles(mapFilesPath);
        return this;
    }

    @Override
    public Marshaller addBeans(InputStream mapsIS) throws MarshallerException {
        this._mappings.loadFromMappingDef(mapsIS);
        return this;
    }

    @Override
    public Marshaller addBeans(Class<?> ... annotatedTypes) throws MarshallerException {
        this._mappings.loadFromAnnotatedClasses(annotatedTypes);
        return this;
    }

    @Override
    public Marshaller usingEncoder(TextEncoder encoder) {
        this._textEncoder = encoder;
        return this;
    }

    @Override
    public <T> T beanFromXml(String beanXml) throws MarshallerException {
        ObjsFromXMLBuilder objBuilder = new ObjsFromXMLBuilder(this._mappings);
        Object outBean = objBuilder.beanFrom(beanXml, this._charSet, this._textEncoder);
        return outBean;
    }

    @Override
    public <T> T beanFromXml(InputStream beanXmlIS) throws MarshallerException {
        ObjsFromXMLBuilder objBuilder = new ObjsFromXMLBuilder(this._mappings);
        Object outBean = objBuilder.beanFrom(beanXmlIS, this._charSet, this._textEncoder);
        return outBean;
    }

    @Override
    public <T> T beanFromXml(Node beanXmlNode) throws MarshallerException {
        ObjsFromXMLBuilder objBuilder = new ObjsFromXMLBuilder(this._mappings);
        Object outBean = objBuilder.beanFrom(beanXmlNode, this._charSet, this._textEncoder);
        return outBean;
    }

    @Override
    public String xmlFromBean(Object bean) throws MarshallerException {
        XMLFromObjsBuilder xmlBuilder = new XMLFromObjsBuilder(this._mappings);
        return xmlBuilder.xmlFrom(bean, this._charSet, this._textEncoder);
    }
}

