/*
 * Decompiled with CFR 0.152.
 */
package r01f.marshalling.simple;

import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import r01f.encoding.TextEncoder;
import r01f.marshalling.MarshallerException;
import r01f.marshalling.MarshallerMappings;
import r01f.marshalling.simple.BeanInstance;
import r01f.marshalling.simple.BeanMap;
import r01f.marshalling.simple.DataTypes;
import r01f.marshalling.simple.FieldInstance;
import r01f.marshalling.simple.FieldMap;
import r01f.marshalling.simple.SimpleMarshallerMappings;
import r01f.util.types.Strings;

final class ObjsFromXMLBuilder<T> {
    private static final Logger log = LoggerFactory.getLogger(ObjsFromXMLBuilder.class);
    private final MarshallerMappings _mappings;

    public ObjsFromXMLBuilder(MarshallerMappings map) {
        this._mappings = map;
    }

    public final T beanFrom(String xmlStr, Charset xmlCharset, TextEncoder encoder) throws MarshallerException {
        if (xmlStr == null) {
            throw new MarshallerException("El XML es nulo; NO se puede obtener un objeto");
        }
        return this._parseXML(Strings.of((CharSequence)xmlStr).asInputStream(), xmlCharset, encoder);
    }

    public final T beanFrom(InputStream is, Charset xmlCharset, TextEncoder encoder) throws MarshallerException {
        if (is == null) {
            throw new MarshallerException("El InputStream al XML es nulo; NO se puede obtener un objeto");
        }
        return this._parseXML(is, xmlCharset, encoder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final T beanFrom(File file, Charset xmlCharset, TextEncoder encoder) throws MarshallerException {
        if (file == null) {
            throw new MarshallerException("XML File is null; NO se puede obtener un objeto");
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                T t = this._parseXML(fis, xmlCharset, encoder);
                return t;
            }
            finally {
                if (Collections.singletonList(fis).get(0) != null) {
                    fis.close();
                }
            }
        }
        catch (FileNotFoundException fnfEx) {
            throw new MarshallerException(fnfEx.getMessage(), fnfEx);
        }
        catch (IOException ioEx) {
            throw new MarshallerException(ioEx.getMessage(), ioEx);
        }
    }

    public final T beanFrom(Node xmlNode, Charset xmlCharset, TextEncoder encoder) throws MarshallerException {
        if (xmlNode == null) {
            throw new MarshallerException("El Node XML es nulo; NO se puede obtener un objeto");
        }
        try {
            DOMSource domSource = new DOMSource(xmlNode);
            ByteArrayOutputStream transformedXML = new ByteArrayOutputStream();
            TransformerFactory.newInstance().newTransformer().transform(domSource, new StreamResult(transformedXML));
            ByteArrayInputStream transformedXMLIS = new ByteArrayInputStream(transformedXML.toByteArray());
            return this._parseXML(transformedXMLIS, xmlCharset, encoder);
        }
        catch (TransformerException trEx) {
            throw new MarshallerException(trEx.getMessage(), trEx);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final T _parseXML(InputStream xmlIS, Charset charset, TextEncoder textEncoder) throws MarshallerException {
        try {
            Charset theCharset = charset != null ? charset : Charset.defaultCharset();
            InputStreamReader isr = new InputStreamReader(xmlIS, theCharset);
            try {
                InputSource is = new InputSource(isr);
                T t = this._parseXML(is, textEncoder);
                return t;
            }
            finally {
                if (Collections.singletonList(isr).get(0) != null) {
                    isr.close();
                }
            }
        }
        catch (IOException ioEx) {
            throw new MarshallerException(ioEx.getMessage(), ioEx);
        }
    }

    private final T _parseXML(InputSource xmlIS, TextEncoder textEncoder) throws MarshallerException {
        if (this._mappings == null) {
            throw new MarshallerException("No se ha establecido el documento de mapeo de beans a XML: Llamar a setBeanMap, o establecerlo en el constructor");
        }
        if (xmlIS == null) {
            return null;
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            ObjsFromXMLLoader loader = new ObjsFromXMLLoader((SimpleMarshallerMappings)this._mappings, textEncoder, log);
            saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", loader);
            saxParser.parse(xmlIS, (DefaultHandler)loader);
            Object outObj = loader.getBuiltObj();
            return (T)outObj;
        }
        catch (SAXException saxEx) {
            Throwable cause = saxEx.getCause();
            if (cause instanceof MarshallerException) {
                throw (MarshallerException)cause;
            }
            throw new MarshallerException(saxEx.getMessage(), saxEx);
        }
        catch (IOException ioEx) {
            throw new MarshallerException(ioEx.getMessage(), ioEx);
        }
        catch (Exception ex) {
            throw new MarshallerException("Error desconocido en el proceso de marshalling:\r\n" + ex.getMessage(), ex);
        }
    }

    private class BeanAndFieldWrapper {
        private final BeanInstance bean;
        private final FieldInstance field;

        public boolean isValid() {
            return this.bean != null && this.field != null;
        }

        public BeanInstance getBean() {
            return this.bean;
        }

        public FieldInstance getField() {
            return this.field;
        }

        @ConstructorProperties(value={"bean", "field"})
        public BeanAndFieldWrapper(BeanInstance bean, FieldInstance field) {
            this.bean = bean;
            this.field = field;
        }
    }

    private class ObjsFromXMLLoader
    extends DefaultHandler
    implements LexicalHandler {
        private final SimpleMarshallerMappings _beanMappings;
        private final TextEncoder _textEncoder;
        private final Logger _log;
        private Object builtObj = null;
        private Deque<BeanAndFieldWrapper> _beanAndFieldStack = new ArrayDeque<BeanAndFieldWrapper>();
        private Deque<String> _beanElementTagNames = new ArrayDeque<String>();
        private Deque<String> _rawXMLTags = new ArrayDeque<String>();
        boolean _loadingChars = true;

        @Override
        public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void endEntity(String arg0) throws SAXException {
        }

        @Override
        public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
        }

        @Override
        public void startEntity(String arg0) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            StringBuilder dbg;
            String eName = lName;
            if ("".equals(eName)) {
                eName = qName;
            }
            StringBuilder stringBuilder = dbg = this._log.isTraceEnabled() ? new StringBuilder(100) : null;
            if (this._log.isTraceEnabled()) {
                dbg.append("[START]: ").append(eName);
            }
            try {
                if (this._rawXMLTags.isEmpty()) {
                    this._beanElementTagNames.push(eName);
                }
                this._loadingChars = true;
                if (this._beanAndFieldStack.isEmpty()) {
                    BeanMap rootBeanMap = this._beanMappings.getBeanMapFromXmlTag(eName);
                    if (rootBeanMap == null) {
                        throw new SAXException("NO se ha podido encontrar un mapeo para el tag " + eName);
                    }
                    BeanInstance rootBeanInstance = this._createBeanInstance(rootBeanMap, eName, attrs);
                    this._beanAndFieldStack.push(new BeanAndFieldWrapper(rootBeanInstance, null));
                    return;
                }
                BeanAndFieldWrapper beanAndField = this._loadingAField(this._beanElementTagNames.peek());
                if (this._log.isTraceEnabled() && beanAndField == null) {
                    dbg.append(" (Collection)");
                }
                if (beanAndField == null) {
                    beanAndField = this._loadingACollection(this._beanElementTagNames.peek());
                }
                if (!this._rawXMLTags.isEmpty()) {
                    this._startElementInRawXml(eName, attrs, beanAndField);
                    return;
                }
                try {
                    FieldMap fieldMap = beanAndField.getField().getMapping();
                    DataTypes.DataType fieldDataType = fieldMap.getDataType();
                    if (!beanAndField.isValid()) {
                        throw new SAXException("NO se ha podido encontrar una instancia para el tag " + eName + " en el bean " + (beanAndField.getBean() != null ? beanAndField.getBean().getMapping().getType() : "NULL") + ": El XML que se esta parseando NO se corresponde con la configuracion del mapeo;\r\nLas causas mas frecuentes del error son:\r\n\t1.- en la definici\u00f3n de mapeo se ha especificado como ATRIBUTO, pero en el XML llega como ELEMENTO.\r\n\t2.- en la definici\u00f3n de mapeo NO se ha incluido el elemento");
                    }
                    if (fieldDataType.isCollection()) {
                        if (fieldMap.getXmlMap().getNodeName().equals(eName)) {
                            this._beanAndFieldStack.push(beanAndField);
                        } else {
                            DataTypes.DataType colElementType = fieldDataType.asCollection().getElementsType();
                            BeanMap colElementBeanMap = colElementType.getBeanMap();
                            if (colElementBeanMap == null && colElementType.getType() == DataTypes.DataTypeEnum.OBJECT && (colElementBeanMap = this._beanMappings.getBeanMapFromXmlTag(eName)) == null) {
                                throw new MarshallerException("La colecci\u00f3n " + fieldMap.getName() + " englobada en el tag " + fieldMap.getXmlMap().getNodeName() + " se ha definido como List/Map SIN indicar el tipo de dato de los elementos (ej: Map(String,com.test.TestBean)); en este caso se intenta averigurar el mapeo de los bean elementos a partir del tag que engloba a cada uno de ellos (" + eName + ") pero TAMPOCO se ha encontrado un bean para este tag; Revisa el fichero de mapeo");
                            }
                            BeanInstance newBeanInstance = this._createBeanInstance(colElementBeanMap, eName, attrs);
                            List instances = (List)beanAndField.getField().getInstance();
                            instances.add(new BeanInstance.CollectionElementBean(eName, newBeanInstance));
                            BeanAndFieldWrapper newBeanAndField = new BeanAndFieldWrapper(newBeanInstance, null);
                            this._beanAndFieldStack.push(newBeanAndField);
                            if (newBeanInstance.getMapping() == null && DataTypes.DataTypeEnum.XML.canBeFromTypeName(fieldDataType.asCollection().getElementsTypeName())) {
                                this._startElementInRawXml(eName, attrs, newBeanAndField);
                            }
                        }
                    } else if (fieldDataType.isObject()) {
                        BeanMap beanMap = fieldMap.getDataType().getBeanMap();
                        BeanInstance newBeanInstance = this._createBeanInstance(beanMap, eName, attrs);
                        beanAndField.getField().setInstance(newBeanInstance);
                        this._beanAndFieldStack.push(beanAndField);
                        this._beanAndFieldStack.push(new BeanAndFieldWrapper(newBeanInstance, null));
                    } else if (fieldDataType.getType() == DataTypes.DataTypeEnum.XML) {
                        this._startElementInRawXml(eName, attrs, beanAndField);
                    } else {
                        fieldDataType.isSimple();
                    }
                }
                catch (MarshallerException xoEx) {
                    throw new SAXException(xoEx);
                }
            }
            finally {
                if (this._log.isTraceEnabled()) {
                    dbg.append(" > OK");
                    this._log.trace(dbg.toString());
                }
            }
        }

        @Override
        public void characters(char[] buff, int offset, int len) throws SAXException {
            StringBuilder dbg;
            if (buff == null || buff.length == 0) {
                return;
            }
            StringBuilder stringBuilder = dbg = this._log.isTraceEnabled() ? new StringBuilder(100) : null;
            if (this._log.isTraceEnabled()) {
                dbg.append("[CHARACTERS]: ").append(this._beanElementTagNames.peek());
            }
            if (!this._loadingChars) {
                return;
            }
            try {
                try {
                    BeanAndFieldWrapper beanAndField = this._loadingAField(this._beanElementTagNames.peek());
                    if (beanAndField != null) {
                        StringBuilder sb = null;
                        if (beanAndField.getField() != null && beanAndField.getField().getMapping().getDataType().isSimple()) {
                            sb = (StringBuilder)beanAndField.getField().getInstance();
                        } else if (beanAndField.getBean().getMapping() == null) {
                            sb = (StringBuilder)beanAndField.getBean().getInstance();
                        }
                        if (sb != null) {
                            StringBuilder text = Strings.create(len + sb.length()).add(buff, offset, len).decodeUsing(this._textEncoder).asStringBuilder();
                            sb.append((CharSequence)text);
                        } else {
                            this._loadingChars = false;
                        }
                    }
                }
                catch (MarshallerException xoEx) {
                    throw new SAXException(xoEx);
                }
            }
            finally {
                if (this._log.isTraceEnabled()) {
                    dbg.append(" > OK");
                    this._log.trace(dbg.toString());
                }
            }
        }

        @Override
        public void startCDATA() throws SAXException {
            if (this._rawXMLTags.isEmpty()) {
                return;
            }
            try {
                BeanAndFieldWrapper beanAndField = this._loadingAField(this._beanElementTagNames.peek());
                StringBuilder xmlSb = null;
                xmlSb = beanAndField.getField() != null ? (StringBuilder)beanAndField.getField().getInstance() : (StringBuilder)beanAndField.getBean().getInstance();
                xmlSb.append("<![CDATA[");
            }
            catch (MarshallerException xoEx) {
                throw new SAXException(xoEx);
            }
        }

        @Override
        public void endCDATA() throws SAXException {
            if (this._rawXMLTags.isEmpty()) {
                return;
            }
            try {
                BeanAndFieldWrapper beanAndField = this._loadingAField(this._beanElementTagNames.peek());
                StringBuilder xmlSb = null;
                xmlSb = beanAndField.getField() != null ? (StringBuilder)beanAndField.getField().getInstance() : (StringBuilder)beanAndField.getBean().getInstance();
                xmlSb.append("]]>");
            }
            catch (MarshallerException xoEx) {
                throw new SAXException(xoEx);
            }
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            StringBuilder dbg;
            String eName = sName;
            if ("".equals(eName)) {
                eName = qName;
            }
            StringBuilder stringBuilder = dbg = this._log.isTraceEnabled() ? new StringBuilder(100) : null;
            if (this._log.isTraceEnabled()) {
                dbg.append("[END]: ").append(eName);
            }
            try {
                BeanAndFieldWrapper beanAndField = this._beanAndFieldStack.peek();
                if (!this._rawXMLTags.isEmpty()) {
                    beanAndField = this._loadingAField(this._beanElementTagNames.peek());
                    this._endElementInRawXml(eName, beanAndField);
                    if (!this._rawXMLTags.isEmpty()) {
                        return;
                    }
                }
                try {
                    if (beanAndField.getBean().getMapping() == null) {
                        this._beanAndFieldStack.pop();
                    } else if (beanAndField.getField() != null && beanAndField.getField().getMapping().getDataType().isCollection()) {
                        this._beanAndFieldStack.pop();
                    } else if (beanAndField.getField() == null && beanAndField.getBean() != null && beanAndField.getBean().getEffectiveNodeName().equals(eName)) {
                        BeanAndFieldWrapper parentBeanAndField;
                        beanAndField.getBean().build();
                        this._beanAndFieldStack.pop();
                        if (!this._beanAndFieldStack.isEmpty() && (parentBeanAndField = this._beanAndFieldStack.peek()).getField() != null && !parentBeanAndField.getField().getMapping().getDataType().isCollection()) {
                            this._beanAndFieldStack.pop();
                        }
                    }
                    this._beanElementTagNames.pop();
                    this._loadingChars = true;
                    if (this._beanAndFieldStack.isEmpty()) {
                        this.builtObj = beanAndField.getBean().getInstance();
                    }
                }
                catch (MarshallerException xoEx) {
                    throw new SAXException(xoEx);
                }
            }
            finally {
                if (this._log.isTraceEnabled()) {
                    dbg.append(" > END");
                    this._log.trace(dbg.toString());
                }
            }
        }

        @Override
        public void endDocument() {
            assert (this._beanAndFieldStack.isEmpty() && this._beanElementTagNames.isEmpty());
        }

        private BeanAndFieldWrapper _loadingAField(String currNodeName) throws MarshallerException {
            BeanAndFieldWrapper beanAndField = this._beanAndFieldStack.peek();
            BeanInstance beanInstance = beanAndField.getBean();
            BeanAndFieldWrapper outBeanAndField = null;
            if (!this._rawXMLTags.isEmpty()) {
                String fieldTag = this._rawXMLTags.peekFirst();
                FieldMap fieldMap = null;
                if (beanInstance.getMapping() == null) {
                    outBeanAndField = this._beanAndFieldStack.peek();
                } else {
                    fieldMap = beanInstance.getMapping().getFieldFromXmlNode(fieldTag, false);
                    outBeanAndField = new BeanAndFieldWrapper(beanInstance, beanInstance.getOrCreateField(fieldMap));
                }
            } else if (beanAndField.getField() == null) {
                if (beanInstance.getMapping() == null) {
                    outBeanAndField = beanAndField;
                } else {
                    FieldMap fieldMap = beanInstance.getMapping().getFieldFromXmlNode(currNodeName, false);
                    if (fieldMap == null && currNodeName.equals(beanInstance.getEffectiveNodeName())) {
                        fieldMap = beanInstance.getMapping().getFieldFromXmlNode(beanInstance.getXmlMap().getNodeName(), false);
                    }
                    if (fieldMap != null && !fieldMap.getDataType().isCollection()) {
                        outBeanAndField = new BeanAndFieldWrapper(beanInstance, beanInstance.getOrCreateField(fieldMap));
                    } else if (fieldMap == null) {
                        outBeanAndField = new BeanAndFieldWrapper(beanInstance, null);
                    }
                }
            }
            return outBeanAndField;
        }

        private BeanAndFieldWrapper _loadingACollection(String currNodeName) throws MarshallerException {
            BeanAndFieldWrapper beanAndColField = this._beanAndFieldStack.peek();
            BeanInstance beanInstance = beanAndColField.getBean();
            FieldInstance colField = beanAndColField.getField();
            FieldMap colFieldMap = null;
            if (colField == null && beanInstance.getMapping() != null) {
                List<FieldMap> colFieldCandidates;
                colFieldMap = beanInstance.getMapping().getFieldFromXmlNode(currNodeName, false);
                if (!(colFieldMap != null && colFieldMap.getDataType().isCollection() || (colFieldCandidates = beanInstance.getMapping().getFieldFromCollecionContaindedBeansXmlNode(currNodeName)) == null)) {
                    for (FieldMap fieldMap : colFieldCandidates) {
                        if (!fieldMap.getXmlMap().getNodeName().equals(beanInstance.getMapping().getXmlMap().getNodeName())) continue;
                        colFieldMap = fieldMap;
                        break;
                    }
                }
                if (colFieldMap != null && colFieldMap.getDataType().isCollection()) {
                    return new BeanAndFieldWrapper(beanInstance, beanInstance.getOrCreateField(colFieldMap));
                }
            } else if (colField != null && colField.getMapping().getDataType().isCollection()) {
                return beanAndColField;
            }
            return null;
        }

        private final BeanInstance _createBeanInstance(BeanMap beanMap, String effectiveNodeName, Attributes attrs) throws MarshallerException {
            BeanInstance beanInstance = new BeanInstance(beanMap, effectiveNodeName);
            int i = 0;
            while (i < attrs.getLength()) {
                FieldMap fieldMap = beanInstance.getMapping().getFieldFromXmlNode(attrs.getQName(i), true);
                if (fieldMap == null) {
                    throw new MarshallerException("NO se ha encontrado un miembro en el que mapear el atributo " + attrs.getQName(i) + " en el bean " + beanInstance.getMapping().getType());
                }
                FieldInstance fieldInstance = beanInstance.getOrCreateField(fieldMap);
                StringBuilder sb = (StringBuilder)fieldInstance.getInstance();
                sb.append(this._textEncoder != null ? this._textEncoder.decode(attrs.getValue(i)) : attrs.getValue(i));
                ++i;
            }
            return beanInstance;
        }

        private void _startElementInRawXml(String tagName, Attributes attrs, BeanAndFieldWrapper beanAndField) {
            String rawXmlEnclosingTag;
            boolean includeCurrentTag = true;
            String string = rawXmlEnclosingTag = this._rawXMLTags.isEmpty() ? null : this._rawXMLTags.peekFirst();
            if (rawXmlEnclosingTag == null || tagName.equals(rawXmlEnclosingTag)) {
                if (this._rawXMLTags.isEmpty()) {
                    includeCurrentTag = false;
                }
                this._rawXMLTags.push(tagName);
            }
            if (includeCurrentTag) {
                StringBuilder xmlSb = null;
                xmlSb = beanAndField.getField() != null ? (StringBuilder)beanAndField.getField().getInstance() : (StringBuilder)beanAndField.getBean().getInstance();
                xmlSb.append("<").append(tagName);
                int i = 0;
                while (i < attrs.getLength()) {
                    xmlSb.append(" ").append(attrs.getQName(i)).append("='").append(attrs.getValue(i)).append("'");
                    ++i;
                }
                xmlSb.append(">");
            }
        }

        private void _endElementInRawXml(String tagName, BeanAndFieldWrapper beanAndField) {
            boolean includeCurrentTag = true;
            String rawXmlEnclosingTag = this._rawXMLTags.peekFirst();
            if (tagName.equals(rawXmlEnclosingTag)) {
                this._rawXMLTags.pop();
                if (this._rawXMLTags.isEmpty()) {
                    includeCurrentTag = false;
                }
            }
            if (includeCurrentTag) {
                StringBuilder xmlSb = null;
                xmlSb = beanAndField.getField() != null ? (StringBuilder)beanAndField.getField().getInstance() : (StringBuilder)beanAndField.getBean().getInstance();
                xmlSb.append("</").append(tagName).append(">");
            }
        }

        public Object getBuiltObj() {
            return this.builtObj;
        }

        @ConstructorProperties(value={"_beanMappings", "_textEncoder", "_log"})
        public ObjsFromXMLLoader(SimpleMarshallerMappings _beanMappings, TextEncoder _textEncoder, Logger _log) {
            this._beanMappings = _beanMappings;
            this._textEncoder = _textEncoder;
            this._log = _log;
        }
    }
}

