/*
 * Decompiled with CFR 0.152.
 */
package r01f.marshalling.simple;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import r01f.marshalling.MarshallerException;
import r01f.marshalling.simple.BeanMap;
import r01f.marshalling.simple.DataTypes;
import r01f.marshalling.simple.FieldMap;
import r01f.marshalling.simple.SimpleMarshallerMappings;

class MarshallerMappingsFromXMLLoader
extends DefaultHandler {
    private static final String CLASSES = "classes";
    private static final String CLASS = "class";
    private static final String USEACCESSORS = "useAccessors";
    private static final String OIDACCESSORMETHOD = "oidAccessorMethod";
    private static final String CUSTOM_MARSHALLER = "customMarshaller";
    private static final String NAME = "name";
    private static final String MEMBER = "member";
    private static final String DATATYPE = "dataType";
    private static final String RELATION = "relation";
    private static final String CREATEMETHOD = "createMethod";
    private static final String ISOID = "isOID";
    private static final String FROMATTRIBUTE = "fromAttribute";
    private static final String FROMELEMENT = "fromElement";
    private static final String OFELEMENTS = "ofElements";
    private static final String ISCDATA = "isCDATA";
    private static final String ISTRANSIENT = "isTransient";
    private Map<String, BeanMap> _loadedBeans;
    private Stack<BeanMap> _beansStack = null;

    MarshallerMappingsFromXMLLoader() {
    }

    @Override
    public void startDocument() {
        this._beansStack = new Stack();
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        String eName = lName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (eName.equalsIgnoreCase(CLASSES)) {
            this._loadedBeans = new HashMap<String, BeanMap>();
        } else if (eName.equalsIgnoreCase(CLASS)) {
            BeanMap newBean = new BeanMap();
            if (attrs != null) {
                if (attrs.getValue(NAME) != null) {
                    newBean.setType(attrs.getValue(NAME).trim());
                }
                if (attrs.getValue(FROMELEMENT) != null) {
                    newBean.getXmlMap().setNodeName(attrs.getValue(FROMELEMENT).trim());
                }
                if (attrs.getValue(USEACCESSORS) != null) {
                    newBean.setUseAccessors(attrs.getValue(USEACCESSORS).trim().equalsIgnoreCase("true"));
                }
                if (attrs.getValue(OIDACCESSORMETHOD) != null) {
                    newBean.setOidAccessorMethod(attrs.getValue(OIDACCESSORMETHOD).trim());
                }
            }
            try {
                MarshallerMappingsFromXMLLoader._checkBean(newBean);
            }
            catch (MarshallerException xoEx) {
                throw new SAXException(xoEx);
            }
            this._beansStack.push(newBean);
        } else if (eName.equalsIgnoreCase(MEMBER)) {
            FieldMap newField = new FieldMap();
            BeanMap currBean = this._beansStack.peek();
            if (attrs != null) {
                String name = null;
                name = attrs.getValue(NAME);
                if (name != null) {
                    newField.setName(name.trim());
                }
                String dataType = null;
                dataType = attrs.getValue(DATATYPE);
                if (dataType != null) {
                    DataTypes.DataType theDataType = DataTypes.DataType.create(dataType.trim());
                    newField.setDataType(theDataType);
                }
                String cdata = null;
                cdata = attrs.getValue(ISCDATA);
                if (cdata != null) {
                    newField.getXmlMap().setCdata(cdata.trim().equals("true"));
                }
                String relation = null;
                relation = attrs.getValue(RELATION);
                if (relation != null) {
                    FieldMap.Relation theRel = FieldMap.Relation.create(relation.trim());
                    if (theRel == null) {
                        throw new SAXException(new MarshallerException("El tipo de relacion '" + relation + "' indicado en el miembro " + newField.getName() + " de la clase " + currBean.getType() + " NO esta soportado. Revisa el documento de mapeo"));
                    }
                    newField.setRelation(theRel);
                }
                String createMethod = null;
                createMethod = attrs.getValue(CREATEMETHOD);
                if (createMethod != null) {
                    newField.setCreateMethod(createMethod.trim());
                }
                String isTransient = null;
                isTransient = attrs.getValue(ISTRANSIENT);
                if (isTransient != null) {
                    newField.setTranzient(isTransient.trim().equals("true"));
                }
                String isOid = null;
                isOid = attrs.getValue(ISOID);
                if (isOid != null) {
                    newField.setOid(isOid.trim().equals("true"));
                }
                String xmlNodeName = null;
                xmlNodeName = attrs.getValue(FROMATTRIBUTE);
                if (xmlNodeName != null) {
                    newField.getXmlMap().setAttribute(true);
                } else {
                    xmlNodeName = attrs.getValue(FROMELEMENT);
                    if (xmlNodeName != null) {
                        newField.getXmlMap().setAttribute(false);
                    }
                }
                newField.getXmlMap().setNodeName(xmlNodeName);
                if (newField.getDataType().isCollection()) {
                    String colElsNodeName = null;
                    colElsNodeName = attrs.getValue(OFELEMENTS);
                    if (colElsNodeName != null) {
                        newField.getXmlMap().setColElsNodeName(colElsNodeName);
                    }
                }
            }
            try {
                currBean.addField(newField);
                MarshallerMappingsFromXMLLoader._checkField(newField);
            }
            catch (MarshallerException xoEx) {
                throw new SAXException(xoEx);
            }
        } else {
            throw new SAXException(new MarshallerException("Error en la configuracion del documento de mapeo: Hay un elemento que no es 'CLASS' o 'MEMBER'"));
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) {
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (eName.equalsIgnoreCase(CLASS)) {
            BeanMap currBean = this._beansStack.pop();
            BeanMap otherBean = this._loadedBeans.put(currBean.getType(), currBean);
            if (otherBean != null) {
                throw new SAXException(new MarshallerException("La clase " + currBean.getType() + " est\u00e1 duplicada en el documento de mapeo, revisalo"));
            }
            int numMatches = 0;
            for (BeanMap anotherBean : this._loadedBeans.values()) {
                if (!anotherBean.getXmlMap().getNodeName().equals(currBean.getXmlMap().getNodeName()) || ++numMatches <= 1) continue;
                throw new SAXException(new MarshallerException("Hay dos calses que se mapean al mismo tag XML: " + currBean.getType() + " y " + anotherBean.getType() + ". Revisa el documento de mapeo"));
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            SimpleMarshallerMappings.connectBeanMappings(this._loadedBeans);
        }
        catch (MarshallerException msEx) {
            throw new SAXException(msEx);
        }
    }

    private static void _checkBean(BeanMap newBean) throws MarshallerException {
        if (newBean.getType() == null) {
            throw new MarshallerException("Hay una clase para la que NO se define nombre. Revisa el documento de mapeo");
        }
        if (newBean.getXmlMap().getNodeName() == null) {
            throw new MarshallerException("La clase " + newBean.getType() + " NO define el nodo XML en la que se mapea. Revisa el documento de mapeo");
        }
    }

    private static void _checkField(FieldMap newField) throws MarshallerException {
        if (newField.getName() == null) {
            throw new MarshallerException("El nombre de un miembro de la clase " + newField.getDeclaringBeanMap().getType() + " NO se ha definido. Revisa el documento de mapeo");
        }
        if (newField.getDataType() == null) {
            throw new MarshallerException("El tipo de datos del miembro " + newField.getName() + " de la clase " + newField.getDeclaringBeanMap().getType() + " NO se ha definido o es incorrecto. Revisa el documento de mapeo");
        }
        if (newField.getXmlMap().isAttribute()) {
            if (newField.getDataType().isCollection()) {
                throw new MarshallerException("Si un miembro se mapea como atributo NO puede ser una coleccion. Revisa el miembro " + newField.getName() + " del bean " + newField.getDeclaringBeanMap().getType());
            }
            if (newField.getDataType().getType() == DataTypes.DataTypeEnum.OBJECT) {
                throw new MarshallerException("Si un miembro se mapea como atributo NO puede ser un objeto 'complejo'. Revisa el miembro " + newField.getName() + " del bean " + newField.getDeclaringBeanMap().getType());
            }
            if (newField.getXmlMap().isCdata()) {
                throw new MarshallerException("Si un miembro se mapea como atributo NO puede ser CDATA. Revisa el miembro " + newField.getName() + " del bean " + newField.getDeclaringBeanMap().getType());
            }
        }
        if (newField.getDataType().isObject()) {
            if (newField.getXmlMap().isCdata()) {
                throw new MarshallerException("Si un miembro es un objeto NO pude ser CDATA. Revisa el miembro " + newField.getName() + " del bean " + newField.getDeclaringBeanMap().getType());
            }
        } else if (newField.getDataType().isSimple() && newField.getDataType().getType() != DataTypes.DataTypeEnum.STRING && newField.getXmlMap().isCdata()) {
            throw new MarshallerException("Si un miembro es un tipo primitivo solo puede ser CDATA si es de tipo String. Revisa el miembro " + newField.getName() + " del bean " + newField.getDeclaringBeanMap().getType());
        }
        if (newField.getXmlMap().isAttribute()) {
            int matchCount = 0;
            for (FieldMap currField : newField.getDeclaringBeanMap().getFields().values()) {
                if (!currField.getXmlMap().isAttribute() || !currField.getXmlMap().getNodeName().equals(newField.getXmlMap().getNodeName()) || ++matchCount <= 1) continue;
                throw new MarshallerException("El miembro " + newField.getName() + " de la clase " + newField.getDeclaringBeanMap().getType() + " se mapea en el atributo " + newField.getXmlMap().getNodeName() + " pero hay otro miembro de la misma clase que tambien se mapea a ese mismo atributo!");
            }
        } else {
            int matchCount = 0;
            for (FieldMap currField : newField.getDeclaringBeanMap().getFields().values()) {
                if (currField.isTranzient() || currField.getXmlMap().isAttribute() || !currField.getXmlMap().getNodeName().equals(newField.getXmlMap().getNodeName()) || ++matchCount <= 1) continue;
                throw new MarshallerException("El miembro " + newField.getName() + " de la clase " + newField.getDeclaringBeanMap().getType() + " se mapea en el elemento " + newField.getXmlMap().getNodeName() + " pero hay otro miembro de la misma clase que tambien se mapea a ese mismo elemento!");
            }
        }
        if (newField.getDataType().isEnum() && newField.getDataType().asEnum().getEnumTypeName() == null) {
            throw new MarshallerException("Si un miembro es Enum, hay que indicar el tipo de enum (ej. Enum(r01f.enums.MyEnum). revisa el nimebro " + newField.getName() + " del bean " + newField.getDeclaringBeanMap().getType());
        }
    }

    public Map<String, BeanMap> getLoadedBeans() {
        return this._loadedBeans;
    }
}

