/*
 * Decompiled with CFR 0.152.
 */
package r01f.marshalling.simple;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import r01f.marshalling.simple.BeanInstance;
import r01f.marshalling.simple.BeanMap;
import r01f.marshalling.simple.DataTypes;
import r01f.marshalling.simple.FieldMap;
import r01f.reflection.Reflection;
import r01f.reflection.ReflectionException;
import r01f.reflection.ReflectionUtils;
import r01f.util.types.Dates;
import r01f.util.types.Strings;
import r01f.util.types.collections.CollectionUtils;

class MappingReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(MappingReflectionUtils.class);

    MappingReflectionUtils() {
    }

    static <T> T createObjectInstance(BeanMap newBeanMap) throws ReflectionException {
        try {
            return Reflection.type(newBeanMap.getType()).load(new Object[0]).instance();
        }
        catch (Throwable th) {
            throw new ReflectionException("NO se ha podido instanciar la clase " + newBeanMap.getType() + ": " + th.getMessage(), th);
        }
    }

    static <T> T getFieldValue(Object obj, String fieldName, boolean useAccessors) {
        return ReflectionUtils.fieldValue(obj, fieldName, useAccessors);
    }

    static Collection<?> getCollectionElements(Object colObj) {
        if (colObj == null) {
            return null;
        }
        Collection<Object> outEls = null;
        if (CollectionUtils.isCollection(colObj.getClass())) {
            outEls = (Set)colObj;
        } else if (CollectionUtils.isMap(colObj.getClass())) {
            outEls = ((Map)colObj).entrySet();
        } else if (colObj.getClass().isArray()) {
            outEls = Arrays.asList((Object[])colObj);
        }
        return outEls;
    }

    static void setFieldValue(Object obj, FieldMap fieldMap, Object value) throws ReflectionException {
        if (value == null) {
            return;
        }
        Object valueObj = null;
        if (value instanceof StringBuilder) {
            valueObj = MappingReflectionUtils._simpleObjFromString(fieldMap.getDataType(), value.toString());
        } else if (value instanceof ArrayList) {
            DataTypes.DataType dataType = fieldMap.getDataType();
            List instances = (List)value;
            DataTypes.DataType colElementsType = dataType.asCollection().getElementsType();
            boolean simpleObjsCol = colElementsType.isSimple();
            Object colElementObj = null;
            if (dataType.isList()) {
                Object[] listInstance = MappingReflectionUtils._listInstance(dataType.getType(), instances.size());
                for (BeanInstance.CollectionElementBean collElementBean : instances) {
                    if (simpleObjsCol) {
                        StringBuilder sb = (StringBuilder)collElementBean.getBeanInstance().getInstance();
                        colElementObj = MappingReflectionUtils._simpleObjFromString(colElementsType, sb.toString());
                    } else {
                        colElementObj = collElementBean.getBeanInstance().getInstance();
                    }
                    if (colElementObj == null) continue;
                    listInstance.add(colElementObj);
                }
                valueObj = dataType.getType() == DataTypes.DataTypeEnum.ARRAY ? listInstance.toArray() : listInstance;
            } else if (dataType.isMap()) {
                Map<Object, Object> mapInstance = MappingReflectionUtils._mapInstance(dataType.getType(), instances.size());
                int i = 1;
                for (BeanInstance.CollectionElementBean collElementBean : instances) {
                    String key = null;
                    BeanInstance beanInstance = collElementBean.getBeanInstance();
                    if (simpleObjsCol) {
                        key = beanInstance.getEffectiveNodeName();
                        StringBuilder sb = (StringBuilder)beanInstance.getInstance();
                        colElementObj = MappingReflectionUtils._simpleObjFromString(colElementsType, sb.toString());
                    } else {
                        FieldMap oidFieldMap = beanInstance.getMapping().getOidField();
                        if (oidFieldMap != null) {
                            key = ReflectionUtils.fieldValue(beanInstance.getInstance(), oidFieldMap.getName(), fieldMap.getDeclaringBeanMap().isUseAccessors());
                        } else {
                            log.warn("Se est\u00e1 indexando el objeto {} en un mapa, pero NO se ha indicado cual el el miembro que hace de OID; es recomendable hacerlo ya que de otra forma se indexa por el nombre del tag mas un n\u00famero", (Object)beanInstance.getMapping().getType());
                            key = String.valueOf(collElementBean.getBeanEnclosingXmlElementName()) + i;
                        }
                        colElementObj = beanInstance.getInstance();
                    }
                    if (colElementObj != null) {
                        mapInstance.put(key, colElementObj);
                    }
                    ++i;
                }
                valueObj = mapInstance;
            }
        } else {
            valueObj = value;
        }
        if (valueObj != null) {
            ReflectionUtils.setFieldValue(obj, fieldMap.getName(), valueObj, fieldMap.getDeclaringBeanMap().isUseAccessors());
        }
    }

    public static String formatAsString(Object value, DataTypes.DataType dataType) {
        String outStrValue = null;
        if (value instanceof Integer) {
            outStrValue = ((Integer)value).toString();
        } else if (value instanceof Long) {
            outStrValue = ((Long)value).toString();
        } else if (value instanceof Double) {
            outStrValue = ((Double)value).toString();
        } else if (value instanceof Float) {
            outStrValue = ((Float)value).toString();
        } else if (value instanceof Boolean) {
            outStrValue = ((Boolean)value).toString();
        } else if (value instanceof java.util.Date || value instanceof Date) {
            String dateFormat = dataType.asDate().getDateFormat();
            outStrValue = Dates.format((java.util.Date)value, dateFormat);
        } else if (ReflectionUtils.isImplementing(value.getClass(), CharSequence.class)) {
            outStrValue = value.toString();
        } else if (value instanceof Enum) {
            outStrValue = ((Enum)value).name();
        }
        return outStrValue;
    }

    public static boolean isSimple(Object value) {
        boolean outSimple = false;
        if (value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Float || value instanceof Boolean || value instanceof java.util.Date || value instanceof Date || ReflectionUtils.isImplementing(value.getClass(), CharSequence.class) || value instanceof Enum) {
            outSimple = true;
        }
        return outSimple;
    }

    private static Object _simpleObjFromString(DataTypes.DataType dataType, String valueStr) {
        String theValueStr;
        boolean ignoreWhiteSpace = true;
        Object outValueObj = null;
        String string = theValueStr = ignoreWhiteSpace ? Strings.of((CharSequence)valueStr).trim().asString() : valueStr;
        if (dataType.getType() == DataTypes.DataTypeEnum.STRING || dataType.getType() == DataTypes.DataTypeEnum.XML) {
            outValueObj = theValueStr;
        } else if (dataType.getType() == DataTypes.DataTypeEnum.STRINGBUFFER) {
            outValueObj = new StringBuffer(theValueStr);
        } else if (dataType.getType() == DataTypes.DataTypeEnum.STRINGBUILDER) {
            outValueObj = new StringBuilder(theValueStr);
        } else if (dataType.getType() == DataTypes.DataTypeEnum.INTEGER || dataType.getType() == DataTypes.DataTypeEnum.INTEGER_P) {
            outValueObj = new Integer(theValueStr);
        } else if (dataType.getType() == DataTypes.DataTypeEnum.LONG || dataType.getType() == DataTypes.DataTypeEnum.LONG_P) {
            outValueObj = new Long(theValueStr);
        } else if (dataType.getType() == DataTypes.DataTypeEnum.DOUBLE || dataType.getType() == DataTypes.DataTypeEnum.DOUBLE_P) {
            outValueObj = new Double(theValueStr);
        } else if (dataType.getType() == DataTypes.DataTypeEnum.FLOAT || dataType.getType() == DataTypes.DataTypeEnum.FLOAT_P) {
            outValueObj = new Float(theValueStr);
        } else if (dataType.getType() == DataTypes.DataTypeEnum.BOOLEAN || dataType.getType() == DataTypes.DataTypeEnum.BOOLEAN_P) {
            if (theValueStr.equalsIgnoreCase("1") || theValueStr.equalsIgnoreCase("true")) {
                theValueStr = "true";
            } else if (valueStr.equalsIgnoreCase("0") || theValueStr.equalsIgnoreCase("false")) {
                theValueStr = "false";
            }
            outValueObj = new Boolean(theValueStr);
        } else if (dataType.isDate()) {
            String format = dataType.asDate().getDateFormat();
            java.util.Date date = Dates.fromFormatedString(theValueStr, format);
            outValueObj = date;
        } else if (dataType.getType() == DataTypes.DataTypeEnum.ENUM) {
            Class<?> enumType = Reflection.type(dataType.asEnum().getEnumTypeName()).getType();
            outValueObj = Enum.valueOf(enumType, theValueStr);
        } else {
            log.error("Marshaller.ObjsFromXMLBuilder: Tipo de dato {} /  {} NO soportado!", (Object)dataType.getName(), (Object)dataType.getType().name());
        }
        return outValueObj;
    }

    private static List<Object> _listInstance(DataTypes.DataTypeEnum listType, int listLength) throws ReflectionException {
        Class listClazz = null;
        switch (listType) {
            case ARRAY: {
                listClazz = ArrayList.class;
                break;
            }
            case LIST: 
            case ARRAYLIST: {
                listClazz = ArrayList.class;
                break;
            }
            case VECTOR: {
                listClazz = Vector.class;
                break;
            }
        }
        return (List)ReflectionUtils.createInstanceOf(listClazz, new Class[]{Integer.TYPE}, new Object[]{new Integer(listLength)}, true);
    }

    private static Map<Object, Object> _mapInstance(DataTypes.DataTypeEnum mapType, int mapLength) throws ReflectionException {
        Class mapClazz = null;
        switch (mapType) {
            case MAP: 
            case HASHMAP: {
                mapClazz = HashMap.class;
                break;
            }
            case HASHTABLE: {
                mapClazz = Hashtable.class;
                break;
            }
            default: {
                throw new ReflectionException("Error: El tipo de mapa NO est\u00e1 definido");
            }
        }
        return (Map)ReflectionUtils.createInstanceOf(mapClazz, new Class[]{Integer.TYPE}, new Object[]{new Integer(mapLength)}, true);
    }
}

