/*
 * Decompiled with CFR 0.152.
 */
package r01f.marshalling.simple;

import java.beans.ConstructorProperties;
import r01f.debug.Debuggable;
import r01f.enums.EnumWithCodeAndLabel;
import r01f.enums.EnumWithCodeAndLabelWrapper;
import r01f.marshalling.simple.BeanMap;
import r01f.marshalling.simple.DataTypes;
import r01f.util.types.Strings;

class FieldMap
implements Debuggable {
    private FieldXMLMap _xmlMap = new FieldXMLMap();
    private BeanMap _declaringBeanMap;
    private String _name;
    private DataTypes.DataType _dataType;
    private Relation _relation;
    private String _createMethod = null;
    private boolean _oid = false;
    private boolean _tranzient = false;

    public FieldMap() {
    }

    public FieldMap(String newName, DataTypes.DataType newDataType, boolean isOid) {
        this();
        this._name = newName;
        this._dataType = newDataType;
        this._oid = isOid;
    }

    @Override
    public String debugInfo() {
        String dbg = Strings.create().add((CharSequence)"\t\t-Field: ").add((CharSequence)this._name).add((CharSequence)" ").addLine(this._xmlMap.debugInfo()).add((CharSequence)"\t\t\tdataType: ").addLine(this._dataType.debugInfo()).add((CharSequence)"\t\t\t   isOid: ").addLine(Boolean.toString(this._oid)).asString();
        return dbg;
    }

    public String toXml() {
        Strings.StringWrapper outField = Strings.create(200);
        if (this._xmlMap.isAttribute()) {
            outField.add((CharSequence)"<member name='{}' dataType='{}' fromAttribute='{}'/>").customizeWith(this._name, this._dataType.getName().replaceAll("\\$", "\\\\\\$"), this._xmlMap.getNodeName());
        } else {
            outField.add((CharSequence)"<member name='{}' dataType='{}' fromElement='{}'").customizeWith(this._name, this._dataType.getName().replaceAll("\\$", "\\\\\\$"), this._xmlMap.getNodeName());
            if (this._dataType.isCollection() && !Strings.isNullOrEmpty(this._xmlMap.getColElsNodeName())) {
                outField.add((CharSequence)" ofElements='{}'").customizeWith(this._xmlMap.getColElsNodeName());
            }
            if (this._xmlMap.isCdata()) {
                outField.add((CharSequence)" isCDATA='true'");
            }
            outField.add((CharSequence)"/>");
        }
        return outField.asString();
    }

    public FieldXMLMap getXmlMap() {
        return this._xmlMap;
    }

    public void setXmlMap(FieldXMLMap _xmlMap) {
        this._xmlMap = _xmlMap;
    }

    public BeanMap getDeclaringBeanMap() {
        return this._declaringBeanMap;
    }

    public void setDeclaringBeanMap(BeanMap _declaringBeanMap) {
        this._declaringBeanMap = _declaringBeanMap;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String _name) {
        this._name = _name;
    }

    public DataTypes.DataType getDataType() {
        return this._dataType;
    }

    public void setDataType(DataTypes.DataType _dataType) {
        this._dataType = _dataType;
    }

    public Relation getRelation() {
        return this._relation;
    }

    public void setRelation(Relation _relation) {
        this._relation = _relation;
    }

    public String getCreateMethod() {
        return this._createMethod;
    }

    public void setCreateMethod(String _createMethod) {
        this._createMethod = _createMethod;
    }

    public boolean isOid() {
        return this._oid;
    }

    public void setOid(boolean _oid) {
        this._oid = _oid;
    }

    public boolean isTranzient() {
        return this._tranzient;
    }

    public void setTranzient(boolean _tranzient) {
        this._tranzient = _tranzient;
    }

    class FieldXMLMap
    implements Debuggable {
        private String _nodeName;
        private boolean _attribute;
        private boolean _cdata;
        private String _colElsNodeName;

        @Override
        public String debugInfo() {
            return Strings.of((CharSequence)"mapped in XML as ").add((CharSequence)(this._attribute ? "attribute" : "element")).add((CharSequence)" ").add((CharSequence)this._nodeName).add((CharSequence)(this._cdata ? " (CDATA)" : "")).asString();
        }

        public String getNodeName() {
            return this._nodeName;
        }

        public void setNodeName(String _nodeName) {
            this._nodeName = _nodeName;
        }

        public boolean isAttribute() {
            return this._attribute;
        }

        public void setAttribute(boolean _attribute) {
            this._attribute = _attribute;
        }

        public boolean isCdata() {
            return this._cdata;
        }

        public void setCdata(boolean _cdata) {
            this._cdata = _cdata;
        }

        public String getColElsNodeName() {
            return this._colElsNodeName;
        }

        public void setColElsNodeName(String _colElsNodeName) {
            this._colElsNodeName = _colElsNodeName;
        }

        public FieldXMLMap() {
        }

        @ConstructorProperties(value={"_nodeName", "_attribute", "_cdata", "_colElsNodeName"})
        public FieldXMLMap(String _nodeName, boolean _attribute, boolean _cdata, String _colElsNodeName) {
            this._nodeName = _nodeName;
            this._attribute = _attribute;
            this._cdata = _cdata;
            this._colElsNodeName = _colElsNodeName;
        }
    }

    public static class Relation {
        private String _name;
        private RelationEnum _relation;

        public static Relation create(String text) {
            Relation outRelation = new Relation();
            outRelation.setName(text);
            outRelation.setRelation(RelationEnum.fromRelationName(text));
            return outRelation;
        }

        public String toString() {
            return this._name;
        }

        public boolean is(RelationEnum relation) {
            return this._relation == relation;
        }

        public boolean isIn(RelationEnum ... relations) {
            return this._relation.isIn(relations);
        }

        public String getName() {
            return this._name;
        }

        public void setName(String _name) {
            this._name = _name;
        }

        public void setRelation(RelationEnum _relation) {
            this._relation = _relation;
        }

        private Relation() {
        }
    }

    public static enum RelationEnum implements EnumWithCodeAndLabel<Integer, RelationEnum>
    {
        NO(-1, "no_relation"),
        COMPOSITION(0, "composition"),
        AGGREGATION(1, "aggregation");

        private final Integer _code;
        private final String _relationName;
        private static EnumWithCodeAndLabelWrapper<Integer, RelationEnum> enums;

        static {
            enums = new EnumWithCodeAndLabelWrapper((EnumWithCodeAndLabel[])RelationEnum.values()).strict();
        }

        @Override
        public boolean is(RelationEnum rel) {
            return this == rel;
        }

        public boolean isIn(RelationEnum ... rels) {
            return enums.isIn(this, rels);
        }

        @Override
        public boolean canBeFrom(String desc) {
            return enums.canBeFrom(desc);
        }

        @Override
        public String getLabel() {
            return this._relationName;
        }

        public static RelationEnum fromCode(int code) {
            return (RelationEnum)enums.fromCode(code);
        }

        public static RelationEnum fromRelationName(String relationName) {
            return enums.from(relationName);
        }

        public static RelationEnum fromName(String name) {
            return (RelationEnum)enums.fromName(name);
        }

        @Override
        public Integer getCode() {
            return this._code;
        }

        public String getRelationName() {
            return this._relationName;
        }

        private RelationEnum(Integer _code, String _relationName) {
            this._code = _code;
            this._relationName = _relationName;
        }
    }
}

