/*
 * Decompiled with CFR 0.152.
 */
package r01f.marshalling.simple;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import r01f.marshalling.MarshallerException;
import r01f.marshalling.simple.BeanInstance;
import r01f.marshalling.simple.FieldMap;

public class FieldInstance {
    private final FieldMap _mapping;
    private Object _instance;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FieldInstance(FieldMap newFieldMap) throws MarshallerException {
        this._mapping = newFieldMap;
        if (this._mapping != null) {
            if (this._mapping.getDataType().isCollection()) {
                ArrayList instances = Lists.newArrayList();
                this._instance = instances;
                return;
            } else if (this._mapping.getDataType().isSimple()) {
                this._instance = new StringBuilder();
                return;
            } else {
                if (!this._mapping.getDataType().isObject()) throw new MarshallerException("El tipo de dato " + this._mapping.getDataType() + " del miembro " + this._mapping.getName() + " del bean " + this._mapping.getDeclaringBeanMap().getType() + " NO es correcto. Revisa el documento de mapeo");
                this._instance = new BeanInstance(this._mapping.getDataType().getBeanMap(), this._mapping.getDataType().getBeanMap().getXmlMap().getNodeName());
            }
            return;
        } else {
            this._instance = new StringBuilder();
        }
    }

    public <T> T getInstance() {
        return (T)this._instance;
    }

    public FieldMap getMapping() {
        return this._mapping;
    }

    public void setInstance(Object _instance) {
        this._instance = _instance;
    }
}

