/*
 * Decompiled with CFR 0.152.
 */
package r01f.marshalling.simple;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import r01f.enums.EnumWithCodeAndMultipleLabels;
import r01f.enums.EnumWithCodeAndMultipleLabelsWrapper;
import r01f.marshalling.simple.BeanMap;
import r01f.util.types.Strings;

public class DataTypes {

    public static abstract class CollectionType
    extends DataType {
        private DataType _elementsType;
        private String _elementsTypeName;

        public CollectionType(String name, DataTypeEnum type, String elsTypeName) {
            super(name, type);
            this._elementsTypeName = elsTypeName;
        }

        public DataType getElementsType() {
            return this._elementsType;
        }

        public void setElementsType(DataType _elementsType) {
            this._elementsType = _elementsType;
        }

        public String getElementsTypeName() {
            return this._elementsTypeName;
        }
    }

    public static class DataType {
        private BeanMap _beanMap;
        private String _name;
        private DataTypeEnum _type;
        private boolean _simple;
        private boolean _map;
        private boolean _list;
        private boolean _enum;
        private boolean _object;
        private boolean _date;

        public DataType(String name, DataTypeEnum type) {
            this._name = name;
            this._type = type;
        }

        public ObjectType asObject() {
            return (ObjectType)this;
        }

        public CollectionType asCollection() {
            return (CollectionType)this;
        }

        public ListCollectionType asList() {
            return (ListCollectionType)this;
        }

        public MapCollectionType asMap() {
            return (MapCollectionType)this;
        }

        public EnumType asEnum() {
            return (EnumType)this;
        }

        public DateType asDate() {
            return (DateType)this;
        }

        public boolean isCollection() {
            return this._map || this._list;
        }

        public String toString() {
            return this._name;
        }

        public String debugInfo() {
            return Strings.of((CharSequence)this._name).add((CharSequence)" -").add((CharSequence)this._type.getTypeNames()[0]).add((CharSequence)"-").asString();
        }

        public static DataType create(String text) {
            boolean isEnum;
            boolean isDate;
            Matcher m;
            Pattern p;
            boolean isMap;
            boolean isObject;
            DataType outDataType = null;
            String name = text;
            DataTypeEnum type = DataTypeEnum.fromTypeName(text);
            boolean bl = isObject = type == DataTypeEnum.OBJECT;
            if (isObject) {
                outDataType = new ObjectType(name, type, !Object.class.getName().equals(name));
            }
            boolean isList = type == DataTypeEnum.LIST || type == DataTypeEnum.VECTOR || type == DataTypeEnum.LIST || type == DataTypeEnum.ARRAY;
            boolean bl2 = isMap = type == DataTypeEnum.MAP || type == DataTypeEnum.HASHMAP || type == DataTypeEnum.HASHTABLE;
            if (isList || isMap) {
                String elsTypeName = null;
                String keyElsTypeName = null;
                p = Pattern.compile("[a-zA-Z.]+(?:\\(([^,]+,?[^,]*)\\))?");
                m = p.matcher(name);
                if (m.find()) {
                    String colType = m.group(1);
                    if (colType != null) {
                        String[] types = colType.split(",");
                        elsTypeName = types.length == 1 ? types[0] : types[1];
                        keyElsTypeName = types.length == 2 ? types[0] : DataTypeEnum.OBJECT.getTypeNames()[0];
                    } else {
                        p = Pattern.compile("([a-zA-Z0-9.$]+)\\[\\s*\\]");
                        m = p.matcher(name);
                        elsTypeName = m.find() ? m.group(1) : DataTypeEnum.OBJECT.getTypeNames()[0];
                    }
                } else {
                    elsTypeName = DataTypeEnum.OBJECT.getTypeNames()[0];
                }
                if (isList && elsTypeName != null) {
                    outDataType = new ListCollectionType(name, type, elsTypeName);
                } else if (isMap && keyElsTypeName != null && elsTypeName != null) {
                    outDataType = new MapCollectionType(name, type, keyElsTypeName, elsTypeName);
                }
            }
            boolean bl3 = isDate = type == DataTypeEnum.SQLDATE || type == DataTypeEnum.DATE;
            if (isDate) {
                String dateFmt = null;
                p = Pattern.compile("[a-zA-Z]+(?:\\((.+)\\))?");
                m = p.matcher(name);
                dateFmt = m.find() ? m.group(1) : "millis";
                outDataType = new DateType(name, type, dateFmt);
            }
            boolean bl4 = isEnum = type == DataTypeEnum.ENUM;
            if (isEnum) {
                String enumTypeName = null;
                Pattern p2 = Pattern.compile("Enum(?:\\((.+)\\))?");
                Matcher m2 = p2.matcher(name);
                if (m2.find()) {
                    enumTypeName = m2.group(1);
                }
                outDataType = new EnumType(name, type, enumTypeName);
            }
            if (outDataType == null) {
                outDataType = new DataType(name, type);
            }
            boolean isSimple = !isList && !isMap && !isObject;
            outDataType.setSimple(isSimple);
            return outDataType;
        }

        public BeanMap getBeanMap() {
            return this._beanMap;
        }

        public void setBeanMap(BeanMap _beanMap) {
            this._beanMap = _beanMap;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String _name) {
            this._name = _name;
        }

        public DataTypeEnum getType() {
            return this._type;
        }

        public void setType(DataTypeEnum _type) {
            this._type = _type;
        }

        public boolean isSimple() {
            return this._simple;
        }

        protected void setSimple(boolean _simple) {
            this._simple = _simple;
        }

        public boolean isMap() {
            return this._map;
        }

        protected void setMap(boolean _map) {
            this._map = _map;
        }

        public boolean isList() {
            return this._list;
        }

        protected void setList(boolean _list) {
            this._list = _list;
        }

        public boolean isEnum() {
            return this._enum;
        }

        protected void setEnum(boolean _enum) {
            this._enum = _enum;
        }

        public boolean isObject() {
            return this._object;
        }

        protected void setObject(boolean _object) {
            this._object = _object;
        }

        public boolean isDate() {
            return this._date;
        }

        protected void setDate(boolean _date) {
            this._date = _date;
        }

        private DataType() {
        }
    }

    public static enum DataTypeEnum implements EnumWithCodeAndMultipleLabels<Integer, DataTypeEnum>
    {
        NULL(-1, "null"),
        STRING(1, "java.lang.String", "String"),
        STRINGBUILDER(2, "java.lang.StringBuilder", "StringBuilder"),
        STRINGBUFFER(3, "java.lang.StringBuffer", "StringBuffer"),
        INTEGER(4, "java.lang.Integer", "Integer"),
        INTEGER_P(5, "int"),
        LONG(6, "java.lang.Long", "Long"),
        LONG_P(7, "long"),
        DOUBLE(8, "java.lang.Double", "Double"),
        DOUBLE_P(9, "double"),
        FLOAT(10, "java.lang.Float", "Float"),
        FLOAT_P(11, "float"),
        BOOLEAN(12, "java.lang.Boolean", "Boolean"),
        BOOLEAN_P(13, "boolean"),
        DATE(14, "java.util.Date", "Date"),
        SQLDATE(15, "java.sql.Date", "SQLDate"),
        OBJECT(16, "java.lang.Object", "Object"),
        XML(17, "XML"),
        MAP(18, "java.util.Map", "Map"),
        HASHTABLE(19, "java.util.Hashtable", "Hashtable"),
        HASHMAP(20, "java.util.HashMap", "HashMap"),
        LIST(21, "java.util.List", "List"),
        VECTOR(22, "java.util.Vector", "Vector"),
        ARRAYLIST(23, "java.util.ArrayList", "ArrayList"),
        ARRAY(24, "Array"),
        ENUM(25, "java.lang.Enum", "Enum");

        private final Integer _code;
        private final String[] _typeNames;
        private static EnumWithCodeAndMultipleLabelsWrapper<Integer, DataTypeEnum> enums;

        static {
            enums = new EnumWithCodeAndMultipleLabelsWrapper((EnumWithCodeAndMultipleLabels[])DataTypeEnum.values()).strict();
        }

        private DataTypeEnum(int code, String ... typeNames) {
            this._code = code;
            this._typeNames = typeNames;
        }

        public boolean canBeFromTypeName(String typeName) {
            return this.canBeFrom(typeName);
        }

        @Override
        public boolean is(DataTypeEnum otherType) {
            return this == otherType;
        }

        public boolean isIn(DataTypeEnum ... dataTypes) {
            return enums.isIn(this, dataTypes);
        }

        @Override
        public boolean canBeFrom(String desc) {
            return enums.canBeFrom(this, desc);
        }

        @Override
        public String getLabel() {
            return this._typeNames != null && this._typeNames.length > 0 ? this._typeNames[0] : null;
        }

        @Override
        public String[] getLabels() {
            return this._typeNames;
        }

        public static DataTypeEnum fromCode(int code) {
            return (DataTypeEnum)enums.fromCode(code);
        }

        public static DataTypeEnum fromTypeName(String typeName) {
            DataTypeEnum theDataType = null;
            try {
                String rawType = typeName;
                Matcher m = Strings.of((CharSequence)typeName).matcher("([a-zA-Z0-9.$]+)(?:\\(.+\\))?");
                if (m.find()) {
                    rawType = m.group(1);
                }
                Pattern p = Pattern.compile(String.valueOf(rawType.replaceAll("\\.", "\\\\\\.")) + "(?:\\(.+\\))?");
                theDataType = (DataTypeEnum)enums.from(typeName, p);
            }
            catch (IllegalArgumentException illArgEx) {
                Matcher m = Strings.of((CharSequence)typeName).matcher("([a-zA-Z0-9.]+)\\[\\s*\\]");
                theDataType = m.find() ? ARRAY : OBJECT;
            }
            return theDataType;
        }

        public static DataTypeEnum fromTypeName(String desc, Pattern regEx) {
            return (DataTypeEnum)enums.from(desc, regEx);
        }

        public static DataTypeEnum fromName(String name) {
            return (DataTypeEnum)enums.fromName(name);
        }

        @Override
        public Integer getCode() {
            return this._code;
        }

        public String[] getTypeNames() {
            return this._typeNames;
        }
    }

    public static class DateType
    extends DataType {
        private String _dateFormat;

        public DateType(String name, DataTypeEnum type, String dateFormat) {
            super(name, type);
            this.setDate(true);
            this._dateFormat = dateFormat;
        }

        public String getDateFormat() {
            return this._dateFormat;
        }
    }

    public static class EnumType
    extends DataType {
        private String _enumTypeName;

        public EnumType(String name, DataTypeEnum type, String enumTypeName) {
            super(name, type);
            this.setEnum(true);
            this._enumTypeName = enumTypeName;
        }

        public String getEnumTypeName() {
            return this._enumTypeName;
        }
    }

    public static class ListCollectionType
    extends CollectionType {
        public ListCollectionType(String name, DataTypeEnum type, String elsTypeName) {
            super(name, type, elsTypeName);
            this.setList(true);
        }
    }

    public static class MapCollectionType
    extends CollectionType {
        private DataType _keyElementsType;
        private String _keyElementsTypeName;

        public MapCollectionType(String name, DataTypeEnum type, String keyElsTypeName, String valueElsTypeName) {
            super(name, type, valueElsTypeName);
            this.setMap(true);
            this._keyElementsTypeName = keyElsTypeName;
        }

        public DataType getKeyElementsType() {
            return this._keyElementsType;
        }

        public void setKeyElementsType(DataType _keyElementsType) {
            this._keyElementsType = _keyElementsType;
        }

        public String getKeyElementsTypeName() {
            return this._keyElementsTypeName;
        }
    }

    public static class ObjectType
    extends DataType {
        private boolean _knownType;

        public ObjectType(String name, DataTypeEnum type, boolean knownType) {
            super(name, type);
            this.setObject(true);
            this._knownType = knownType;
        }

        public boolean isKnownType() {
            return this._knownType;
        }
    }
}

