/*
 * Decompiled with CFR 0.152.
 */
package r01f.marshalling.simple;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import r01f.marshalling.MarshallerException;
import r01f.marshalling.simple.DataTypes;
import r01f.marshalling.simple.FieldMap;
import r01f.util.types.Strings;

class BeanMap {
    private BeanXMLMap _xmlMap = new BeanXMLMap();
    private String _type;
    private boolean _useAccessors = true;
    private Map<String, FieldMap> _fields;
    private String _oidAccessorMethod;
    private Map<String, FieldMap> _attrFieldsByXmlNodeName;
    private Map<String, FieldMap> _elementsFieldsByXmlNodeName;
    private Map<String, List<FieldMap>> _colFieldsContainingBeansEnclosedByXmlNodeName;
    private FieldMap _oidField;

    public BeanMap() {
    }

    public BeanMap(String newType) {
        this();
        this._type = newType;
    }

    public FieldMap getFieldFromXmlNode(String xmlNodeName, boolean isAttribute) {
        if (this._fields == null) {
            return null;
        }
        FieldMap outField = null;
        if (isAttribute && this._attrFieldsByXmlNodeName != null) {
            outField = this._attrFieldsByXmlNodeName.get(xmlNodeName);
        } else if (this._elementsFieldsByXmlNodeName != null) {
            outField = this._elementsFieldsByXmlNodeName.get(xmlNodeName);
        }
        return outField;
    }

    public List<FieldMap> getFieldFromCollecionContaindedBeansXmlNode(String beanTag) {
        if (this._fields == null || this._colFieldsContainingBeansEnclosedByXmlNodeName == null) {
            return null;
        }
        List<FieldMap> outFields = this._colFieldsContainingBeansEnclosedByXmlNodeName.get(beanTag);
        if (outFields != null && !outFields.isEmpty()) {
            return outFields;
        }
        return null;
    }

    public FieldMap getOidField() {
        if (this._fields == null) {
            return null;
        }
        return this._oidField;
    }

    public FieldMap getField(String fieldName) {
        if (this._fields == null) {
            return null;
        }
        return this._fields.get(fieldName);
    }

    public void addField(FieldMap newField) throws MarshallerException {
        newField.setDeclaringBeanMap(this);
        if (newField.getName() != null) {
            FieldMap other;
            if (this._fields == null) {
                this._fields = new HashMap<String, FieldMap>();
            }
            if ((other = this._fields.put(newField.getName(), newField)) != null) {
                throw new MarshallerException("El miembro " + newField.getName() + " ya existe en la clase " + this.getType() + ": hay dos miembros con el mismo nombre para la misma clase en el fichero de mapeo!");
            }
        }
    }

    void initIndexes() {
        if (this._fields == null) {
            return;
        }
        for (FieldMap fm : this._fields.values()) {
            if (!fm.isOid()) continue;
            this._oidField = fm;
            break;
        }
        HashMap<String, FieldMap> attrs = new HashMap<String, FieldMap>();
        HashMap<String, FieldMap> els = new HashMap<String, FieldMap>();
        for (FieldMap fm : this._fields.values()) {
            if (fm.getXmlMap().isAttribute()) {
                attrs.put(fm.getXmlMap().getNodeName(), fm);
                continue;
            }
            els.put(fm.getXmlMap().getNodeName(), fm);
        }
        if (attrs.size() > 0) {
            this._attrFieldsByXmlNodeName = new HashMap<String, FieldMap>(attrs.size(), 1.0f);
            this._attrFieldsByXmlNodeName.putAll(attrs);
        }
        if (els.size() > 0) {
            this._elementsFieldsByXmlNodeName = new HashMap<String, FieldMap>(els.size(), 1.0f);
            this._elementsFieldsByXmlNodeName.putAll(els);
        }
        HashMap<String, ArrayList<FieldMap>> colEls = new HashMap<String, ArrayList<FieldMap>>();
        for (FieldMap fm : this._fields.values()) {
            BeanMap colElsBeanMap;
            DataTypes.DataType dataType = fm.getDataType();
            if (!dataType.isCollection() || dataType.asCollection().getElementsType().isSimple() || (colElsBeanMap = dataType.asCollection().getElementsType().getBeanMap()) == null) continue;
            String elXmlEnclosingTag = colElsBeanMap.getXmlMap().getNodeName();
            ArrayList<FieldMap> colFields = (ArrayList<FieldMap>)colEls.get(elXmlEnclosingTag);
            if (colFields == null) {
                colFields = new ArrayList<FieldMap>();
                colEls.put(elXmlEnclosingTag, colFields);
            }
            colFields.add(fm);
        }
        if (colEls.size() > 0) {
            this._colFieldsContainingBeansEnclosedByXmlNodeName = new HashMap<String, List<FieldMap>>(colEls.size(), 1.0f);
            this._colFieldsContainingBeansEnclosedByXmlNodeName.putAll(colEls);
        }
    }

    public String debugInfo() {
        Strings.StringWrapper sw = Strings.create().add((CharSequence)">> Bean: ").add((CharSequence)this.getType()).add((CharSequence)" ").addLine(this.getXmlMap().debugInfo()).add((CharSequence)"\toidAccessorMethod: ").addLine(this.getOidAccessorMethod()).add((CharSequence)"\t     useAccessors: ").addLine(Boolean.toString(this.isUseAccessors()));
        if (this.getFields() != null) {
            sw.addLine("\tFields:");
            for (FieldMap fmap : this.getFields().values()) {
                sw.add((CharSequence)fmap.debugInfo());
            }
        }
        return sw.asString();
    }

    public String toXml() {
        String clsOpen = Strings.create(200).add((CharSequence)"<class name='{}' fromElement='{}' useAccessors='{}'>").customizeWith(this._type.replaceAll("\\$", "\\\\\\$"), this._xmlMap.getNodeName(), Boolean.toString(this._useAccessors)).asString();
        StringBuffer fields = new StringBuffer(600);
        for (FieldMap fm : this._fields.values()) {
            fields.append("\r\n\t").append(fm.toXml());
        }
        String clsEnd = "\r\n</class>";
        return String.valueOf(clsOpen) + fields.toString() + clsEnd;
    }

    public BeanXMLMap getXmlMap() {
        return this._xmlMap;
    }

    public void setXmlMap(BeanXMLMap _xmlMap) {
        this._xmlMap = _xmlMap;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String _type) {
        this._type = _type;
    }

    public boolean isUseAccessors() {
        return this._useAccessors;
    }

    public void setUseAccessors(boolean _useAccessors) {
        this._useAccessors = _useAccessors;
    }

    public Map<String, FieldMap> getFields() {
        return this._fields;
    }

    public void setFields(Map<String, FieldMap> _fields) {
        this._fields = _fields;
    }

    public String getOidAccessorMethod() {
        return this._oidAccessorMethod;
    }

    public void setOidAccessorMethod(String _oidAccessorMethod) {
        this._oidAccessorMethod = _oidAccessorMethod;
    }

    class BeanXMLMap {
        private String _nodeName;

        public String debugInfo() {
            return Strings.of((CharSequence)"mapped in XML tag ").add((CharSequence)this._nodeName).asString();
        }

        public String getNodeName() {
            return this._nodeName;
        }

        public void setNodeName(String _nodeName) {
            this._nodeName = _nodeName;
        }

        public BeanXMLMap() {
        }

        @ConstructorProperties(value={"_nodeName"})
        public BeanXMLMap(String _nodeName) {
            this._nodeName = _nodeName;
        }
    }
}

