/*
 * Decompiled with CFR 0.152.
 */
package r01f.marshalling.simple;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import r01f.marshalling.MarshallerException;
import r01f.marshalling.simple.BeanMap;
import r01f.marshalling.simple.DataTypes;
import r01f.marshalling.simple.FieldInstance;
import r01f.marshalling.simple.FieldMap;
import r01f.marshalling.simple.MappingReflectionUtils;
import r01f.reflection.ReflectionException;
import r01f.util.types.collections.CollectionUtils;

class BeanInstance {
    private final BeanMap _mapping;
    private final String _effectiveNodeName;
    private final Map<String, FieldInstance> _fields;
    private Object _instance;

    public BeanInstance() throws MarshallerException {
        this(null, null);
    }

    public BeanInstance(BeanMap newBeanMap, String effectiveNodeName) throws MarshallerException {
        this._effectiveNodeName = effectiveNodeName;
        this._mapping = newBeanMap;
        this._fields = newBeanMap != null ? new HashMap<String, FieldInstance>(newBeanMap.getFields().size()) : null;
        try {
            this._instance = this._mapping != null ? MappingReflectionUtils.createObjectInstance(this._mapping) : new StringBuilder();
        }
        catch (ReflectionException refEx) {
            throw new MarshallerException("Error al crear una instancia de la clase " + this._mapping.getType() + ". Posiblemente NO tenga un constructor SIN argumentos o NO se encuentra la clase: " + refEx.getMessage(), refEx);
        }
    }

    public <T> T getInstance() {
        return (T)this._instance;
    }

    public BeanMap.BeanXMLMap getXmlMap() {
        return this._mapping.getXmlMap();
    }

    public FieldInstance getOrCreateField(FieldMap fieldMap) throws MarshallerException {
        if (fieldMap == null) {
            return null;
        }
        FieldInstance fieldInstance = null;
        if (!this._fields.isEmpty()) {
            fieldInstance = this._fields.get(fieldMap.getXmlMap().getNodeName());
        }
        if (fieldInstance == null) {
            fieldInstance = new FieldInstance(fieldMap);
            this._fields.put(fieldMap.getXmlMap().getNodeName(), fieldInstance);
        }
        return fieldInstance;
    }

    public Object build() {
        if (this._instance == null) {
            return null;
        }
        if (this.getMapping() == null) {
            return this._instance;
        }
        for (FieldInstance fieldInstance : this._fields.values()) {
            if (fieldInstance.getInstance() == null) continue;
            Object value = null;
            DataTypes.DataType fieldDataType = fieldInstance.getMapping().getDataType();
            if (fieldDataType.isCollection()) {
                List instances = (List)fieldInstance.getInstance();
                if (!CollectionUtils.isNullOrEmpty(instances)) {
                    value = instances;
                }
            } else if (fieldDataType.isSimple()) {
                StringBuilder valueStr = (StringBuilder)fieldInstance.getInstance();
                if (valueStr != null) {
                    value = valueStr;
                }
            } else if (fieldDataType.isObject()) {
                BeanInstance instance = (BeanInstance)fieldInstance.getInstance();
                value = instance.getInstance();
            }
            if (value == null) continue;
            MappingReflectionUtils.setFieldValue(this._instance, fieldInstance.getMapping(), value);
        }
        return this._instance;
    }

    public BeanMap getMapping() {
        return this._mapping;
    }

    public String getEffectiveNodeName() {
        return this._effectiveNodeName;
    }

    public Map<String, FieldInstance> getFields() {
        return this._fields;
    }

    public void setInstance(Object _instance) {
        this._instance = _instance;
    }

    static class CollectionElementBean {
        private final String _beanEnclosingXmlElementName;
        private final BeanInstance _beanInstance;

        public String getBeanEnclosingXmlElementName() {
            return this._beanEnclosingXmlElementName;
        }

        public BeanInstance getBeanInstance() {
            return this._beanInstance;
        }

        @ConstructorProperties(value={"_beanEnclosingXmlElementName", "_beanInstance"})
        public CollectionElementBean(String _beanEnclosingXmlElementName, BeanInstance _beanInstance) {
            this._beanEnclosingXmlElementName = _beanEnclosingXmlElementName;
            this._beanInstance = _beanInstance;
        }
    }
}

