/*
 * Decompiled with CFR 0.152.
 */
package r01f.marshalling;

import com.google.inject.Guice;
import com.google.inject.Key;
import com.google.inject.Module;
import java.io.ByteArrayInputStream;
import java.text.NumberFormat;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import r01f.encoding.TextEncoder;
import r01f.marshalling.MarsallerGuiceModule;
import r01f.marshalling.Marshaller;
import r01f.marshalling.MarshallerException;
import r01f.marshalling.TestObj;
import r01f.marshalling.annotations.SingleUseSimpleMarshaller;
import r01f.util.types.Strings;
import r01f.xml.XMLStringSerializer;

public class TestXOMarshaller {
    private static final Logger log = LoggerFactory.getLogger(TestXOMarshaller.class);

    public static void main(String[] args) {
        try {
            Marshaller marshallerV2;
            TextEncoder encoder = new TextEncoder(){

                @Override
                public CharSequence encode(CharSequence theText) {
                    return Strings.of(theText).asXml().encodeUTFDoubleByteCharsAsEntities();
                }

                @Override
                public CharSequence decode(CharSequence theText) {
                    return Strings.of(theText).asXml().decodeUTFDoubleByteCharsFromEntities();
                }
            };
            int times = 1;
            long[][] marks = new long[times][2];
            boolean debug = true;
            boolean testV2 = true;
            boolean testV1 = false;
            boolean useSameXML = !testV1;
            boolean testReverse = true;
            TextEncoder textEncoder = testV1 ? null : null;
            String v2mapXML = testV2 ? TestXOMarshaller._builV2dMapping() : null;
            Marshaller marshaller = marshallerV2 = testV2 ? ((Marshaller)Guice.createInjector((Module[])new Module[]{new MarsallerGuiceModule()}).getInstance(Key.get(Marshaller.class, SingleUseSimpleMarshaller.class))).usingEncoder(textEncoder) : null;
            if (testV2) {
                marshallerV2.addBeans(Strings.of((CharSequence)v2mapXML).asInputStream());
            }
            String xmlV2 = TestXOMarshaller._buildTesXML(!useSameXML);
            TestObj obj = null;
            String reveseXML = null;
            System.gc();
            System.gc();
            if (testV2) {
                System.out.println(">>>> Testing V2");
                int i = 0;
                while (i < times) {
                    if (!debug && i % 80 == 0) {
                        System.out.println("");
                    }
                    if (!debug) {
                        System.out.print(".");
                    }
                    long t1 = System.nanoTime();
                    obj = (TestObj)marshallerV2.beanFromXml(xmlV2);
                    if (testReverse) {
                        obj.setNotMappedField("Not Mapped");
                        reveseXML = marshallerV2.xmlFromBean(obj);
                    }
                    long t2 = System.nanoTime();
                    marks[i][0] = t2 - t1;
                    if (debug) {
                        System.out.println(obj.toString());
                        if (testReverse) {
                            System.out.println(XMLStringSerializer.beautfyXMLString(reveseXML));
                            obj = (TestObj)marshallerV2.beanFromXml(reveseXML);
                            System.out.println(obj.toString());
                        }
                    }
                    ++i;
                }
                System.out.println("[END]");
            }
            System.out.println("\r\n\r\n\r\n\t[V2]\t\t[V1]");
            long v1Avg = 0L;
            long v2Avg = 0L;
            NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
            int i = 0;
            while (i < times) {
                System.out.println("<" + i + ">\t[" + nf.format(marks[i][0]) + "]\t[" + nf.format(marks[i][1]) + "]");
                if (i > 0) {
                    v2Avg += marks[i][0];
                    v1Avg += marks[i][1];
                }
                ++i;
            }
            System.out.println("------------------------------");
            double avg2millis = (double)(v2Avg / (long)times) / Math.pow(10.0, 6.0);
            double avg1millis = (double)(v1Avg / (long)times) / Math.pow(10.0, 6.0);
            System.out.println("\t[" + nf.format(avg2millis) + " ms]\t[" + nf.format(avg1millis) + " ms]\r\n\r\n");
        }
        catch (Throwable th) {
            th.printStackTrace(System.out);
        }
    }

    public static Marshaller marshaller() throws MarshallerException {
        String mapXML = TestXOMarshaller._builV2dMapping();
        Marshaller outMarshaller = ((Marshaller)Guice.createInjector((Module[])new Module[]{new MarsallerGuiceModule()}).getInstance(Key.get(Marshaller.class, SingleUseSimpleMarshaller.class))).addBeans(new ByteArrayInputStream(mapXML.getBytes()));
        return outMarshaller;
    }

    private static String _buildTesXML(boolean v1) {
        StringBuilder testXML = new StringBuilder();
        testXML.append("<testObj long='5' date='1971/03/25'>");
        testXML.append("\t<str><![CDATA[String Field]]></str>").append("\t<xml>").append("\t\tXML Field<otherTag>OtherText</otherTag>").append("\t\t<xml><otherTag>OtherText</otherTag></xml>").append("\t\t<![CDATA[texto cdata]]>").append("\t</xml>").append("\t<![CDATA[texto cdata]]>");
        testXML.append("\t<listOfStrings>").append("\t\t<string>String1</string>").append("\t\t<string>String2</string>").append("\t\t<string>String3</string>").append("\t</listOfStrings>");
        testXML.append("\t<childObj key='theKey0' value='theValue'>").append("\t\t<otherChildObj key='theKey01'>theValue01</otherChildObj>").append("\t</childObj>");
        if (!v1) {
            testXML.append("<childObjFake key='theKey01' value='theValue01'/>");
        }
        testXML.append("    <mapOfUnknownObjs>").append("        <childObj key='childObjKey' value='childObjValue'/>").append("        <otherChildObj key='otherChildObjKey'>otherChildObjValue</otherChildObj>").append("    </mapOfUnknownObjs>");
        testXML.append("    <listOfUnknownObjs>").append("        <childObj key='childObjKey' value='childObjValue'/>").append("        <otherChildObj key='otherChildObjKey'>otherChildObjValue</otherChildObj>").append("    </listOfUnknownObjs>");
        if (!v1) {
            testXML.append("").append("<listOfXMLs>").append("\t<xml><kk><a><![CDATA[XML-1]]></a></kk></xml>").append("\t<xml><b>XML-2</b></xml>").append("\t<xml><c>XML-3</c></xml>").append("</listOfXMLs>");
            testXML.append("<listOfDates>").append("\t<date>25/03/1971</date>").append("\t<date>26/03/1972</date>").append("\t<date>27/03/1973</date>").append("</listOfDates>");
            testXML.append("<mapOfXMLs>").append("\t<xml1><a><![CDATA[XML-1]]></a></xml1>").append("\t<xml2><b>XML-2</b></xml2>").append("\t<xml3><c>XML-3</c></xml3>").append("</mapOfXMLs>");
        }
        testXML.append("\t<listOfChildObjs>");
        if (!v1) {
            testXML.append("\t<childObjFake key='theKey00' value='theValue00'>").append("\t\t<otherChildObj key='theKey001'>theValue001</otherChildObj>").append("\t\t<mapOfTestOtherChildObj>").append("\t\t\t<otherChildObj key='theKey311'>theValue311</otherChildObj>").append("\t\t\t<otherChildObj key='theKey312'>theValue312</otherChildObj>").append("\t\t</mapOfTestOtherChildObj>").append("\t</childObjFake>").append("\t<childObjFake key='theKey01' value='theValue01'/>").append("\t<childObjFake key='theKey02' value='theValue02'/>");
        } else {
            testXML.append("\t<childObj key='theKey00' value='theValue00'>").append("\t\t<otherChildObj key='theKey001'>theValue001</otherChildObj>").append("\t\t<mapOfTestOtherChildObj>").append("\t\t\t<otherChildObj key='theKey311'>theValue311</otherChildObj>").append("\t\t\t<otherChildObj key='theKey312'>theValue312</otherChildObj>").append("\t\t</mapOfTestOtherChildObj>").append("\t</childObj>").append("\t<childObj key='theKey01' value='theValue01'/>").append("\t<childObj key='theKey02' value='theValue02'/>");
        }
        testXML.append("\t</listOfChildObjs>");
        testXML.append("\t<objectArr>").append("\t\t<childObj key='theKey00' value='theValue00'/>").append("\t\t<childObj key='theKey01' value='theValue01'/>").append("\t\t<childObj key='theKey02' value='theValue02'/>").append("\t</objectArr>");
        testXML.append("\t<mapOfStrings>").append("\t\t<string1>String1 Value</string1>").append("\t\t<string2>String2 Value</string2>").append("\t\t<string3>String3 Value</string3>").append("\t</mapOfStrings>");
        testXML.append("\t<mapOfChildObjs>").append("\t\t<childObj key='theKey4' value='theValue4'/>").append("\t\t<childObj key='theKey3' value='theValue3'>");
        if (!v1) {
            testXML.append("\t\t<mapOfLongs>").append("\t\t\t<long1>45</long1>").append("\t\t\t<long2>-12</long2>").append("\t\t</mapOfLongs>");
        }
        testXML.append("\t\t\t<otherChildObj key='theKey31'>theValue31</otherChildObj>");
        testXML.append("\t\t\t<mapOfTestOtherChildObj>").append("\t\t\t\t<otherChildObj key='theKey311'>theValue311</otherChildObj>").append("\t\t\t\t<otherChildObj key='theKey312'>theValue312</otherChildObj>").append("\t\t\t</mapOfTestOtherChildObj>");
        testXML.append("\t\t</childObj>");
        testXML.append("\t</mapOfChildObjs>");
        testXML.append("\tje je je je");
        testXML.append("</testObj>");
        return testXML.toString();
    }

    private static String _builV2dMapping() {
        StringBuilder mapXML = new StringBuilder();
        mapXML.append("<classes>").append("\t\t<class name='r01f.marshalling.TestObj' fromElement='testObj' useAccessors='true'>").append("\t\t\t<member name='selfStrField' dataType='String' fromElement='testObj'/>").append("\t\t\t<member name='strField' dataType='String' fromElement='str'/>").append("\t\t\t<member name='longField' dataType='long' fromAttribute='long'/>").append("\t\t\t<member name='dateField' dataType='Date(yyyy/MM/dd)' fromAttribute='date'/>").append("\t\t\t<member name='xmlField' dataType='XML' fromElement='xml'/>").append("\t\t\t<member name='childObjField' dataType='r01f.marshalling.TestChildObj' fromElement='childObj'/>").append("\t\t\t<member name='otherChildObjField' dataType='r01f.marshalling.TestChildObj' fromElement='childObjFake'/>").append("\t\t\t<member name='objectArrField' dataType='r01f.marshalling.TestChildObj[]' fromElement='objectArr'/>").append("\t\t\t<member name='listOfChildObjField' dataType='java.util.List(r01f.marshalling.TestChildObj)' fromElement='listOfChildObjs' ofElements='childObjFake'/>").append("\t\t\t<member name='listOfXMLsField' dataType='java.util.List(XML)' fromElement='listOfXMLs' ofElements='xml'/>").append("\t\t\t<member name='listOfStringsField' dataType='List(String)' fromElement='listOfStrings' ofElements='string' isCDATA='true'/>").append("\t\t\t<member name='listOfDatesField' dataType='List(Date(dd/MM/yyyy))' fromElement='listOfDates' ofElements='date'/>").append("\t\t\t<member name='mapOfUnknownObjsField' dataType='java.util.Map(java.lang.String,java.lang.Object)' fromElement='mapOfUnknownObjs'/>").append("\t\t\t<member name='listOfUnknownObjsField' dataType='List(Object)' fromElement='listOfUnknownObjs'/>").append("\t\t\t<member name='mapOfStringsField' dataType='Map(java.lang.String,String)' fromElement='mapOfStrings' ofElements='string' isCDATA='true'/>").append("\t\t\t<member name='mapOfXMLsField' dataType='Map(String,XML)' fromElement='mapOfXMLs'/>").append("\t\t\t<member name='mapOfChildObjsField' dataType='java.util.Map(String,r01f.marshalling.TestChildObj)' fromElement='mapOfChildObjs'/>").append("\t\t</class>").append("\t\t<class name='r01f.marshalling.TestChildObj' fromElement='childObj' useAccessors='true'>").append("\t\t\t<member name='keyField' dataType='String' fromAttribute='key' isOID='true'/>").append("\t\t\t<member name='valueField' dataType='String' fromAttribute='value'/>").append("\t\t\t<member name='otherChildObjField' dataType='r01f.marshalling.TestOtherChildObj' fromElement='otherChildObj'/>").append("\t\t\t<member name='mapOfTestOtherChildObjField' dataType='Map(String,r01f.marshalling.TestOtherChildObj)' fromElement='mapOfTestOtherChildObj'/>").append("\t\t\t<member name='mapOfLongsField' dataType='Map(String,long)' fromElement='mapOfLongs' ofElements='long'/>").append("\t\t</class>").append("\t\t<class name='r01f.marshalling.TestOtherChildObj' fromElement='otherChildObj' useAccessors='true'>").append("\t\t\t<member name='keyField' dataType='String' fromAttribute='key' isOID='true'/>").append("\t\t\t<member name='valueField' dataType='String' fromElement='otherChildObj'/>").append("\t\t</class>").append("</classes>");
        return mapXML.toString();
    }

    private static String _builV1dMapping() {
        StringBuilder mapXML = new StringBuilder();
        mapXML.append("<classes>").append("\t\t<class name='TestObj' package='r01f.marshalling' fromElement='testObj' useAccessors='true'>").append("\t\t\t<member name='strField' dataType='String' fromElement='str'/>").append("\t\t\t<member name='longField' dataType='long' fromAttribute='long'/>").append("\t\t\t<member name='dateField' dataType='Date(yyyy/MM/dd)' fromAttribute='date'/>").append("\t\t\t<member name='xmlField' dataType='XML' fromElement='xml'/>").append("\t\t\t<member name='childObjField' dataType='TestChildObj' fromElement='childObj'/>").append("\t\t\t<member name='objectArrField' dataType='TestChildObj' collection='Array' fromElement='objectArr'/>").append("\t\t\t<member name='listOfChildObjField' dataType='List' fromElement='listOfChildObjs' />").append("\t\t\t<member name='listOfStringsField' collection='List' dataType='String' fromElement='listOfStrings'/>").append("\t\t\t<member name='mapOfStringsField' dataType='Map' fromElement='mapOfStrings'/>").append("\t\t\t<member name='mapOfChildObjsField' dataType='Map' fromElement='mapOfChildObjs'/>").append("\t\t</class>").append("\t\t<class name='TestChildObj' package='r01f.marshalling' fromElement='childObj' useAccessors='true'>").append("\t\t\t<member name='keyField' dataType='String' fromAttribute='key' isOID='true'/>").append("\t\t\t<member name='valueField' dataType='String' fromAttribute='value'/>").append("\t\t\t<member name='otherChildObjField' dataType='TestOtherChildObj' fromElement='otherChildObj'/>").append("\t\t\t<member name='mapOfTestOtherChildObjField' dataType='Map' fromElement='mapOfTestOtherChildObj'/>").append("\t\t</class>").append("\t\t<class name='TestOtherChildObj' package='r01f.marshalling' fromElement='otherChildObj' useAccessors='true'>").append("\t\t\t<member name='keyField' dataType='String' fromAttribute='key' isOID='true'/>").append("\t\t\t<member name='valueField' dataType='String' fromElement='otherChildObj'/>").append("\t\t</class>").append("</classes>");
        return mapXML.toString();
    }
}

