/*
 * Decompiled with CFR 0.152.
 */
package r01f.locale;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import java.util.Locale;
import r01f.internal.BootstrapGuiceModule;
import r01f.locale.I18NBundle;
import r01f.locale.I18NLocalized;
import r01f.locale.I18NMessageBundleService;
import r01f.locale.I18NService;
import r01f.locale.I18NServiceFactory;

public class TestI18N {
    public static void main(String[] args) {
        try {
            int testTimes = 1;
            Locale loc = new Locale("es", "ES");
            Injector injector = Guice.createInjector((Module[])new Module[]{new BootstrapGuiceModule(), new TestI18NModule()});
            I18NServicedObject i18n = (I18NServicedObject)injector.getInstance(I18NServicedObject.class);
            int i = 0;
            while (i < testTimes) {
                System.out.println("\r\n\r\n\r\n[OPCION 1]--------------------------------------------------------------");
                String msg1 = i18n.getI18nIOC1().forLocale(loc).message("child.test");
                System.out.println("\r\nMensajes: " + msg1);
                System.out.println("\r\n\r\n\r\n[OPCION 2]--------------------------------------------------------------");
                String parentKey = i18n.getI18nIOC2().forLocale(loc).message("parent.test");
                String childKey = i18n.getI18nIOC2().forLocale(loc).message("child.test");
                String noKey = i18n.getI18nIOC2().forLocale(loc).message("nonExistentKey");
                System.out.println("\r\nMensajes: " + parentKey + " / " + childKey + " / " + noKey);
                System.out.println("\r\n\r\n\r\n[OPCION 3]--------------------------------------------------------------");
                String msg = i18n.getI18nIOC3().forLocale(loc).message("child.test");
                System.out.println("\r\nMensajes: " + msg);
                if (i < testTimes - 1) {
                    Thread.sleep(100L);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    @I18NLocalized
    public static class I18NServicedObject {
        @Inject
        @Named(value="myBundle")
        private I18NService _i18nIOC1;
        @I18NMessageBundleService(chain={"components.myParentBundle", "components.myChildBundle"}, missingKeyBehaviour=I18NBundle.MissingKeyBehaviour.RETURN_NULL, resourcesLoaderDef="r01fb/test/properties/resourcesLoader[@name='myClassPathResourcesLoader']")
        private I18NService _i18nIOC2;
        Injector injector = Guice.createInjector((Module[])new Module[]{new BootstrapGuiceModule()});
        private I18NService _i18nIOC3 = ((I18NServiceFactory)this.injector.getInstance(I18NServiceFactory.class)).usingDefaultResourcesLoader().forBundleChain(new String[]{"components.myParentBundle", "components.myChildBundle"}).withMissingKeyBehaviour(I18NBundle.MissingKeyBehaviour.RETURN_NULL);

        public I18NService getI18nIOC1() {
            return this._i18nIOC1;
        }

        public I18NService getI18nIOC2() {
            return this._i18nIOC2;
        }

        public I18NService getI18nIOC3() {
            return this._i18nIOC3;
        }
    }

    public static class TestI18NModule
    implements Module {
        public void configure(Binder binder) {
        }

        @Provides
        @Named(value="myBundle")
        public I18NService newMyBundle(I18NServiceFactory serviceFactory) {
            return serviceFactory.usingResourcesLoaderDefinedIn("r01fb/test/properties/resourcesLoader[@name='myClassPathResourcesLoader']").forBundleChain(new String[]{"components.myParentBundle", "components.myChildBundle"}).withMissingKeyBehaviour(I18NBundle.MissingKeyBehaviour.RETURN_NULL);
        }
    }
}

