/*
 * Decompiled with CFR 0.152.
 */
package r01f.locale;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import r01f.locale.Language;
import r01f.util.types.Strings;

public class LanguageTexts
implements Map<Language, String> {
    private Map<Language, String> _texts;
    private LangTextNotFoundBehabiour _behabiour = LangTextNotFoundBehabiour.RETURN_NULL;
    private String _defaultValue = "*** No text for {} ***";

    public static LanguageTexts of(Language lang, String text) {
        LanguageTexts outTexts = new LanguageTexts();
        outTexts.addForLang(lang, text);
        return outTexts;
    }

    public static LanguageTexts withMissingLangTextBehabiour(LangTextNotFoundBehabiour behabiour) {
        LanguageTexts outTexts = new LanguageTexts();
        outTexts.missingLangTextBehabiour(behabiour);
        return outTexts;
    }

    public LanguageTexts missingLangTextBehabiour(LangTextNotFoundBehabiour behabiour) {
        this._behabiour = behabiour;
        return this;
    }

    public LanguageTexts defaultTextWhenLangTextMissing(String defaultValue) {
        this._defaultValue = defaultValue;
        return this;
    }

    public LanguageTexts addForLang(Language lang, String text) {
        this.put(lang, text);
        return this;
    }

    public String forLang(Language lang) throws IllegalArgumentException {
        String outText = this.get((Object)lang);
        if (outText != null || this._behabiour != LangTextNotFoundBehabiour.RETURN_NULL) {
            if (outText == null && this._behabiour == LangTextNotFoundBehabiour.RETURN_DEFAULT_VALUE) {
                outText = this._defaultValue != null ? Strings.of((CharSequence)this._defaultValue).customizeWith(lang.getLocale().toString()).asString() : null;
            } else if (outText == null && this._behabiour == LangTextNotFoundBehabiour.THROW_EXCEPTION) {
                String msg = Strings.of((CharSequence)this._defaultValue).customizeWith(lang.getLocale().toString()).asString();
                throw new IllegalArgumentException(msg);
            }
        }
        return outText;
    }

    @Override
    public int size() {
        return this._texts != null ? this._texts.size() : 0;
    }

    @Override
    public boolean isEmpty() {
        return this._texts != null ? this._texts.isEmpty() : true;
    }

    @Override
    public boolean containsKey(Object lang) {
        return this._texts != null ? this._texts.containsKey(lang) : false;
    }

    @Override
    public boolean containsValue(Object text) {
        return this._texts != null ? this._texts.containsValue(text) : false;
    }

    @Override
    public String get(Object lang) {
        return this._texts != null ? this._texts.get(lang) : null;
    }

    @Override
    public String put(Language lang, String text) {
        if (this._texts == null) {
            this._texts = Maps.newTreeMap();
        }
        return this._texts.put(lang, text);
    }

    @Override
    public String remove(Object lang) {
        return this._texts != null ? this._texts.remove(lang) : null;
    }

    @Override
    public void putAll(Map<? extends Language, ? extends String> m) {
        if (this._texts == null) {
            this._texts = new HashMap<Language, String>(m.size());
        }
        this._texts.putAll(m);
    }

    @Override
    public void clear() {
        if (this._texts != null) {
            this._texts.clear();
        }
    }

    @Override
    public Set<Language> keySet() {
        return this._texts != null ? this._texts.keySet() : null;
    }

    @Override
    public Collection<String> values() {
        return this._texts != null ? this._texts.values() : null;
    }

    @Override
    public Set<Map.Entry<Language, String>> entrySet() {
        return this._texts != null ? this._texts.entrySet() : null;
    }

    public static enum LangTextNotFoundBehabiour {
        RETURN_NULL,
        RETURN_DEFAULT_VALUE,
        THROW_EXCEPTION;

    }
}

