/*
 * Decompiled with CFR 0.152.
 */
package r01f.locale;

import java.util.Locale;

public enum Language {
    SPANISH(new Locale("es", "ES")),
    BASQUE(new Locale("eu", "ES")),
    ENGLISH(new Locale("en", "EN")),
    FRENCH(new Locale("fr", "FR")),
    DEUTCH(new Locale("de", "DE")),
    UNKNOWN(null);

    public static Language DEFAULT;
    private Locale _locale;

    static {
        DEFAULT = SPANISH;
    }

    private Language(Locale loc) {
        this._locale = loc;
    }

    public static Language forLocale(Locale loc) {
        Language outLang = null;
        Language[] languageArray = Language.values();
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language lang = languageArray[n2];
            if (lang != UNKNOWN && lang.getLocale().equals(loc)) {
                outLang = lang;
                break;
            }
            ++n2;
        }
        return outLang;
    }

    public static Language forLang(String language) {
        Language outLang = null;
        Language[] languageArray = Language.values();
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language lang = languageArray[n2];
            if (lang != UNKNOWN && lang.getLocale().getLanguage().equals(language)) {
                outLang = lang;
                break;
            }
            ++n2;
        }
        return outLang;
    }

    public static Language forLang(String language, String country) {
        Language outLang = null;
        Language[] languageArray = Language.values();
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language lang = languageArray[n2];
            if (lang != UNKNOWN && lang.getLocale().getLanguage().equals(language) && lang.getLocale().getCountry().equals(country)) {
                outLang = lang;
                break;
            }
            ++n2;
        }
        return outLang;
    }

    public Locale getLocale() {
        return this._locale;
    }
}

