/*
 * Decompiled with CFR 0.152.
 */
package r01f.locale;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import r01f.locale.I18NBundle;
import r01f.locale.I18NService;
import r01f.resources.ResourcesLoader;
import r01f.resources.ResourcesLoaderDef;
import r01f.resources.ResourcesLoaderDefLoader;
import r01f.resources.ResourcesLoaderFactory;
import r01f.resources.ResourcesReloadControl;
import r01f.resources.ResourcesReloadControlDef;

public class I18NServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(I18NServiceFactory.class);
    final ConcurrentMap<String, I18NService> _serviceCache = new ConcurrentHashMap<String, I18NService>();
    @Inject
    private ResourcesLoaderDefLoader _resourcesLoaderDefLoader;
    @Inject
    private ResourcesLoaderFactory _resourcesLoaderFactory;

    public I18NServiceProvider usingResourcesLoaderDefinedIn(String resLoaderDefId) {
        I18NServiceProvider sp = new I18NServiceProvider(this._resourcesLoaderDefLoader, this._resourcesLoaderFactory, resLoaderDefId);
        return sp;
    }

    public I18NServiceProvider usingResourcesLoader(ResourcesLoader resLoader, ResourcesReloadControl resReloadControl) {
        I18NServiceProvider sp = new I18NServiceProvider(this._resourcesLoaderDefLoader, this._resourcesLoaderFactory, resLoader, resReloadControl);
        return sp;
    }

    public I18NServiceProvider usingDefaultResourcesLoader() {
        I18NServiceProvider sp = new I18NServiceProvider(this._resourcesLoaderDefLoader, this._resourcesLoaderFactory);
        return sp;
    }

    public class I18NServiceProvider {
        private final ResourcesLoaderDefLoader _resourcesLoaderDefLoader;
        private final ResourcesLoaderFactory _resourcesLoaderFactory;
        private ResourcesLoader _resourcesLoader;
        private ResourcesReloadControl _resourcesReloadControl;
        private I18NBundle.MissingKeyBehaviour _missingKeyBehaviour;

        public I18NServiceProvider(ResourcesLoaderDefLoader resLoaderDefLoader, ResourcesLoaderFactory resLoaderFactory) {
            this._resourcesLoaderDefLoader = resLoaderDefLoader;
            this._resourcesLoaderFactory = resLoaderFactory;
        }

        public I18NServiceProvider(ResourcesLoaderDefLoader resLoaderDefLoader, ResourcesLoaderFactory resLoaderFactory, ResourcesLoader resLoader, ResourcesReloadControl resReloadControl) {
            this(resLoaderDefLoader, resLoaderFactory);
            this._resourcesLoader = resLoader;
            this._resourcesReloadControl = resReloadControl;
        }

        public I18NServiceProvider(ResourcesLoaderDefLoader resLoaderDefLoader, ResourcesLoaderFactory resLoaderFactory, String resLoaderDefId) {
            this(resLoaderDefLoader, resLoaderFactory);
            ResourcesLoaderDef resLoaderDef = this._resourcesLoaderDefLoader.loadForDefLocation(resLoaderDefId);
            this._resourcesLoader = this._resourcesLoaderFactory.createResourcesLoaderFor(resLoaderDef);
            this._resourcesReloadControl = resLoaderDef.getReloadControlDef() != null ? this._resourcesLoaderFactory.createReloadControlFor(resLoaderDef.getReloadControlDef()) : this._resourcesLoaderFactory.createReloadControlFor(ResourcesReloadControlDef.DEFAULT);
        }

        public I18NService forBundleChain(String bundleChain) {
            String[] bundleChainSplitted = bundleChain.split(",");
            return this.forBundleChain(bundleChainSplitted);
        }

        public I18NService forBundleChain(String[] bundleChain) {
            return this.forBundleChain(bundleChain, I18NBundle.MissingKeyBehaviour.THROW_EXCEPTION);
        }

        public I18NService forBundleChain(String[] bundleChain, I18NBundle.MissingKeyBehaviour missingKeyBehaviour) {
            String cacheKey;
            I18NService outService = null;
            if (bundleChain != null && bundleChain.length > 0 && (outService = (I18NService)I18NServiceFactory.this._serviceCache.get(cacheKey = bundleChain.toString())) == null) {
                outService = new I18NService(this._resourcesLoader, this._resourcesReloadControl, bundleChain, missingKeyBehaviour);
                I18NServiceFactory.this._serviceCache.putIfAbsent(cacheKey, outService);
                outService = (I18NService)I18NServiceFactory.this._serviceCache.get(cacheKey);
            }
            return outService;
        }
    }
}

