/*
 * Decompiled with CFR 0.152.
 */
package r01f.locale;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import r01f.locale.I18NBundle;
import r01f.locale.I18NResourceBundleControl;
import r01f.resources.ResourcesLoader;
import r01f.resources.ResourcesLoaderDef;
import r01f.resources.ResourcesLoaderFactory;
import r01f.resources.ResourcesReloadControl;

public class I18NService {
    private static final Logger log = LoggerFactory.getLogger(I18NService.class);
    private final ConcurrentMap<Locale, I18NBundle> _bundleCache = new ConcurrentHashMap<Locale, I18NBundle>();
    private final I18NResourceBundleControl _control;
    private final String[] _bundleChain;
    private I18NBundle.MissingKeyBehaviour _missingKeyBehaviour;
    private boolean _devMode;

    I18NService(ResourcesLoader resLoader, ResourcesReloadControl resReloadControl, String[] bundleChain, I18NBundle.MissingKeyBehaviour missingKeyBehaviour) {
        this._control = new I18NResourceBundleControl(resLoader, resReloadControl);
        this._bundleChain = bundleChain;
        this._missingKeyBehaviour = missingKeyBehaviour == null ? I18NBundle.MissingKeyBehaviour.THROW_EXCEPTION : missingKeyBehaviour;
    }

    I18NService(ResourcesLoaderFactory resLoaderFactory, ResourcesLoaderDef resLoaderDef, String[] bundleChain, I18NBundle.MissingKeyBehaviour missingKeyBehaviour) {
        this._control = new I18NResourceBundleControl(resLoaderFactory, resLoaderDef);
        this._bundleChain = bundleChain;
        this._missingKeyBehaviour = missingKeyBehaviour == null ? I18NBundle.MissingKeyBehaviour.THROW_EXCEPTION : missingKeyBehaviour;
    }

    public final I18NBundle forLocale(Locale locale) {
        I18NBundle outBundle = (I18NBundle)this._bundleCache.get(locale);
        if (outBundle == null) {
            outBundle = new I18NBundle(this._control, this._bundleChain, this._missingKeyBehaviour, this._devMode, locale);
            this._bundleCache.putIfAbsent(locale, outBundle);
            outBundle = (I18NBundle)this._bundleCache.get(locale);
        }
        return outBundle;
    }

    public final String toString() {
        return this._bundleChain.toString();
    }

    public I18NService withMissingKeyBehaviour(I18NBundle.MissingKeyBehaviour behaviour) {
        this._missingKeyBehaviour = behaviour;
        return this;
    }

    public I18NService inDevMode() {
        log.warn("El i18NService est\u00e1 en MODO DEVELOPER lo que hace que se cargue los ResourceBundles CADA VEZ QUE SE ACCEDE A UNA CLAVE. Esta caracter\u00edstica viene bien para DESARROLLAR pero NUNCA activarla en modo PRODUCTIVO!!!");
        this._devMode = true;
        return this;
    }
}

