/*
 * Decompiled with CFR 0.152.
 */
package r01f.locale;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import r01f.resources.ResourcesLoader;
import r01f.resources.ResourcesLoaderDef;
import r01f.resources.ResourcesLoaderFactory;
import r01f.resources.ResourcesReloadControl;
import r01f.resources.ResourcesReloadControlDef;

public class I18NResourceBundleControl
extends ResourceBundle.Control {
    private static final Logger log = LoggerFactory.getLogger(I18NResourceBundleControl.class);
    private ResourcesLoader _resourcesLoader;
    private ResourcesReloadControl _reloadControl;

    public I18NResourceBundleControl(ResourcesLoaderFactory resLoaderFactory, ResourcesLoaderDef resLoaderDef) {
        this._resourcesLoader = resLoaderFactory.createResourcesLoaderFor(resLoaderDef);
        ResourcesReloadControlDef reloadControlDef = resLoaderDef.getReloadControlDef();
        if (reloadControlDef != null) {
            ResourcesReloadControl theReloadControl = null;
            theReloadControl = resLoaderFactory.createReloadControlFor(reloadControlDef);
            theReloadControl.setProperties(reloadControlDef.getControlProps());
            this._reloadControl = theReloadControl;
        }
    }

    public I18NResourceBundleControl(ResourcesLoader resLoader, ResourcesReloadControl resReloadControl) {
        this._resourcesLoader = resLoader;
        this._reloadControl = resReloadControl;
    }

    @Override
    public List<String> getFormats(String baseName) {
        if (baseName == null) {
            throw new NullPointerException();
        }
        return FORMAT_PROPERTIES;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        if (baseName == null || locale == null || format == null || loader == null) {
            throw new NullPointerException("I18NResourceBoundle.Control baseName, locale, format and loader must NOT be null");
        }
        PropertyResourceBundle outBundle = null;
        if (format.equals("java.properties")) {
            String resourceExtension = format.substring(5);
            String resourceName = this.toResourceName(this.toBundleName(baseName, locale), resourceExtension);
            System.out.print("....." + resourceName + ": " + reload);
            InputStream is = this._resourcesLoader.getInputStream(resourceName, reload);
            if (is != null) {
                outBundle = new PropertyResourceBundle(is);
            }
        } else {
            throw new IllegalArgumentException("ResourceBundle: unknown format: " + format);
        }
        return outBundle;
    }

    @Override
    public long getTimeToLive(String baseName, Locale locale) {
        if (baseName == null || locale == null) {
            throw new NullPointerException("I18NResourceBoundle.Control baseName, and locale must NOT be null");
        }
        long outTTL = -2L;
        if (this._reloadControl != null) {
            outTTL = this._resourcesLoader.getConfig().getReloadControlDef().checkIntervalMillis();
        }
        return outTTL;
    }

    @Override
    public boolean needsReload(String baseName, Locale locale, String format, ClassLoader loader, ResourceBundle bundle, long loadTime) {
        boolean outReload = false;
        try {
            if (bundle == null) {
                throw new NullPointerException("I18NResourceBoundle.Control bundle must NOT be null");
            }
            if (this._reloadControl != null && format.equals("java.properties")) {
                String resourceExtension = format.substring(5);
                String resourceName = this.toResourceName(this.toBundleName(baseName, locale), resourceExtension);
                outReload = this._reloadControl.needsReload(resourceName);
            }
        }
        catch (Throwable th) {
            log.error("Error desconocido al evaluar si hay que recargar un ResourceBundle", th);
        }
        return outReload;
    }
}

