/*
 * Decompiled with CFR 0.152.
 */
package r01f.locale;

import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import r01f.locale.I18NBundle;
import r01f.locale.I18NMessageBundleService;
import r01f.locale.I18NService;
import r01f.locale.I18NServiceFactory;
import r01f.reflection.ReflectionUtils;
import r01f.util.types.Strings;

public class I18NMessageAnnotationGuiceHandler
implements TypeListener {
    public <I> void hear(final TypeLiteral<I> type, TypeEncounter<I> encounter) {
        final ReflectionUtils.FieldAnnotated[] fieldsAnnotatedWithI18N = ReflectionUtils.fieldsAnnotated(type.getRawType(), I18NMessageBundleService.class);
        if (fieldsAnnotatedWithI18N != null && fieldsAnnotatedWithI18N.length > 0) {
            final Provider serviceFactory = encounter.getProvider(I18NServiceFactory.class);
            encounter.register(new MembersInjector<I>(){

                public void injectMembers(I instance) {
                    ReflectionUtils.FieldAnnotated[] fieldAnnotatedArray = fieldsAnnotatedWithI18N;
                    int n = fieldsAnnotatedWithI18N.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ReflectionUtils.FieldAnnotated fieldAnnotatedWitI18N = fieldAnnotatedArray[n2];
                        if (!fieldAnnotatedWitI18N.getField().getType().isAssignableFrom(I18NService.class)) {
                            throw new IllegalStateException(Strings.of((CharSequence)"Field {} of type {} must be of type {} to be injected with a {}").customizeWith(fieldAnnotatedWitI18N.getField().getName(), instance.getClass().getCanonicalName(), I18NService.class.getName(), I18NService.class.getName()).asString());
                        }
                        I18NMessageBundleService annotation = (I18NMessageBundleService)fieldAnnotatedWitI18N.getAnnotation();
                        String[] theBundleChain = annotation.chain();
                        if (theBundleChain != null && theBundleChain.length > 0) {
                            String[] stringArray = theBundleChain;
                            int n3 = theBundleChain.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String c = stringArray[n4];
                                if (c.length() == 0) {
                                    c = type.getRawType().getName().replace('.', '/');
                                }
                                if (c.startsWith("/")) {
                                    c = c.substring(1);
                                }
                                ++n4;
                            }
                        }
                        if (!I18NMessageAnnotationGuiceHandler._isValidBundleChain(theBundleChain)) {
                            throw new IllegalStateException(Strings.of((CharSequence)"Field {} of type {} annotated with {} must have a 'chain' attribute of type String[] with the names of the Bundles of the chain").customizeWith(fieldAnnotatedWitI18N.getField().getName(), instance.getClass().getCanonicalName(), I18NService.class.getName()).asString());
                        }
                        I18NBundle.MissingKeyBehaviour theMissingKeyBehaviour = annotation.missingKeyBehaviour();
                        I18NService service = ((I18NServiceFactory)serviceFactory.get()).usingResourcesLoaderDefinedIn(annotation.resourcesLoaderDef()).forBundleChain(theBundleChain).withMissingKeyBehaviour(theMissingKeyBehaviour);
                        ReflectionUtils.setFieldValue(instance, fieldAnnotatedWitI18N.getField(), (Object)service, false);
                        ++n2;
                    }
                }
            });
        }
    }

    static final boolean _isValidBundleChain(String[] theBundleChain) {
        if (theBundleChain == null || theBundleChain.length == 0) {
            return false;
        }
        boolean outValid = true;
        String[] stringArray = theBundleChain;
        int n = theBundleChain.length;
        int n2 = 0;
        while (n2 < n) {
            String bundle = stringArray[n2];
            if (Strings.isNullOrEmpty(bundle)) {
                outValid = false;
                break;
            }
            ++n2;
        }
        return outValid;
    }
}

