/*
 * Decompiled with CFR 0.152.
 */
package r01f.locale;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import r01f.locale.I18NMissingMessageException;
import r01f.locale.I18NResourceBundleControl;

public class I18NBundle {
    private static final Logger log = LoggerFactory.getLogger(I18NBundle.class);
    private final I18NResourceBundleControl _control;
    private final String[] _bundleChain;
    private final Locale _locale;
    private final MissingKeyBehaviour _missingKeyBehaviour;
    private boolean _devMode;

    I18NBundle(I18NResourceBundleControl control, String[] bundleChain, MissingKeyBehaviour missingKeyBehaviour, boolean devMode, Locale locale) {
        this._control = control;
        this._bundleChain = bundleChain;
        this._missingKeyBehaviour = missingKeyBehaviour;
        this._devMode = devMode;
        this._locale = locale;
    }

    public List<String> keys() {
        LinkedList<String> outKeys = new LinkedList<String>();
        String[] stringArray = this._bundleChain;
        int n = this._bundleChain.length;
        int n2 = 0;
        while (n2 < n) {
            String bundle = stringArray[n2];
            Enumeration<String> en = this._retrieveBundle(bundle).getKeys();
            while (en.hasMoreElements()) {
                outKeys.add(en.nextElement());
            }
            ++n2;
        }
        return outKeys;
    }

    public boolean hasKey(String key) {
        boolean containsKey = false;
        String[] stringArray = this._bundleChain;
        int n = this._bundleChain.length;
        int n2 = 0;
        while (n2 < n) {
            String bundle = stringArray[n2];
            containsKey = this._retrieveBundle(bundle).containsKey(key);
            if (containsKey) break;
            ++n2;
        }
        return containsKey;
    }

    public final String message(String key) throws I18NMissingMessageException {
        return this.message(key, null);
    }

    public final String message(String key, Object ... params) throws I18NMissingMessageException {
        if (key == null) {
            throw new IllegalArgumentException("Cannot load bundle key: Missing key!");
        }
        String outValue = this._retrieveMessage(key);
        if (outValue == null || outValue.length() == 0) {
            switch (this._missingKeyBehaviour) {
                case RETURN_KEY: {
                    outValue = "[" + key + "]";
                    break;
                }
                case RETURN_NULL: {
                    outValue = null;
                    break;
                }
                case THROW_EXCEPTION: {
                    throw new I18NMissingMessageException(key, this._locale, this._bundleChain);
                }
            }
        }
        return outValue == null || params == null || params.length == 0 ? outValue : MessageFormat.format(outValue, params);
    }

    public final Map<String, String> messagesWithKeysStartingWith(String keyPrefix) {
        if (keyPrefix == null) {
            throw new IllegalArgumentException("Cannot load bundle key: Missing key!");
        }
        HashMap<String, String> outMessages = new HashMap<String, String>();
        try {
            int i = 0;
            while (i < this._bundleChain.length) {
                String thisBundle = this._bundleChain[i];
                ResourceBundle bundle = this._retrieveBundle(thisBundle);
                Enumeration<String> keys = bundle.getKeys();
                if (keys != null && keys.hasMoreElements()) {
                    do {
                        String key;
                        String msg;
                        String string = msg = (key = keys.nextElement()).startsWith(keyPrefix) ? bundle.getString(key) : null;
                        if (msg == null) continue;
                        outMessages.put(key, msg);
                    } while (keys.hasMoreElements());
                }
                ++i;
            }
        }
        catch (MissingResourceException mrEx) {
            log.error("No se ha podido cargar el Resource bundle de la cadena {}", (Object)this._bundleChain, (Object)mrEx);
        }
        return outMessages;
    }

    public final String toString() {
        return this._bundleChain + " (" + this._locale + ")";
    }

    private final String _retrieveMessage(String key) throws I18NMissingMessageException {
        String outKey = null;
        try {
            int i = 0;
            while (i < this._bundleChain.length) {
                String thisBundle = this._bundleChain[i];
                ResourceBundle bundle = this._retrieveBundle(thisBundle);
                try {
                    outKey = bundle.getString(key);
                }
                catch (MissingResourceException mkEx) {
                    if (i == this._bundleChain.length - 1) {
                        log.warn("NO se encuentra la clave {} en NINGUNO de los bundles de la cadena {}", (Object)key, (Object)this._bundleChain);
                    }
                    log.warn("NO se encuentra la clave {} en el bundle {}; se mira en el siguiente bundle de la cadena {}", new Object[]{key, this._bundleChain[i], this._bundleChain[i + 1]});
                }
                if (outKey == null) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (MissingResourceException mrEx) {
            log.error("No se ha podido cargar el Resource bundle de la cadena {}", (Object)this._bundleChain, (Object)mrEx);
        }
        return outKey;
    }

    private ResourceBundle _retrieveBundle(String bundleName) {
        if (this._devMode) {
            ResourceBundle.clearCache();
        }
        ResourceBundle outBundle = ResourceBundle.getBundle(bundleName, this._locale, this._control);
        return outBundle;
    }

    public static enum MissingKeyBehaviour {
        THROW_EXCEPTION,
        RETURN_NULL,
        RETURN_KEY;

    }
}

